package com.biz.crm.mdm.business.customer.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 客户上传文件Vo
 *
 * @author ning.zhang
 * @date 2021/10/25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerUploadVo", description = "客户上传文件Vo")
public class CustomerMediaVo extends TenantVo {

  private static final long serialVersionUID = 795455873596207789L;

  /**
   * 文件名称
   */
  @ApiModelProperty("文件名称")
  private String fileName;
  /**
   * 文件地址
   */
  @ApiModelProperty("文件地址")
  private String url;
  /**
   * 文件类型(1:企业证书照片,2:法人身份证照片)
   */
  @ApiModelProperty("文件类型(1:企业证书照片,2:法人身份证照片)")
  private String fileType;
}
