package com.biz.crm.mdm.business.customer.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Author: zengxingwang
 * @Date: 2021/12/21 19:23
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CustomerVo", description = "客户信息Vo")
public class CustomerTagVo extends TenantFlagOpVo {

  /**
   * 标签名称
   */
  @ApiModelProperty("标签名称")
  private String tagName;

  /**
   * 标签说明
   */
  @ApiModelProperty("标签说明")
  private String tagDescription;

  /**
   * 标签人数
   */
  @ApiModelProperty("标签人数")
  private Integer tagNum;

  /**
   * 更新方式（0：实时更新；1：定时更新）
   */
  @ApiModelProperty("更新方式（0：实时更新；1：定时更新）")
  private String updateType ;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;
}
