package com.biz.crm.mdm.business.customer.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.business.common.sdk.vo.WorkflowFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.xml.bind.annotation.W3CDomHandler;
import java.math.BigDecimal;
import java.util.List;

/**
 * 客户信息Vo
 *
 * @author ning.zhang
 * @date 2021/10/25
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CustomerVo", description = "客户信息Vo")
public class CustomerVo extends WorkflowFlagOpVo {

  private static final long serialVersionUID = 8073395713409568682L;



  /**
   * id
   */
  @ApiModelProperty("ID")
  private String id;
  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channel;
  /**
   * 渠道名称
   */
  @ApiModelProperty("渠道名称")
  private String channelName;
  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;
  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;
  /**
   * 客户编码/客户名称
   */
  @ApiModelProperty("客户编码/客户名称")
  private String unionName;
  /**
   * 所属客户组织编码
   */
  @ApiModelProperty("所属客户组织编码")
  private String customerOrgCode;
  /**
   * 所属客户组织名称
   */
  @ApiModelProperty("所属客户组织名称")
  private String customerOrgName;
  /**
   * 客户类型
   */
  @ApiModelProperty("客户类型")
  private String customerType;
  /**
   * 操作类型
   */
  @ApiModelProperty("操作类型")
  private String operateType;
  /**
   * 所属企业组织编码
   */
  @ApiModelProperty("所属企业组织编码")
  private String orgCode;
  /**
   * 所属企业组织名称
   */
  @ApiModelProperty("所属企业组织名称")
  private String orgName;
  /**
   * 市级编码
   */
  @ApiModelProperty("市级编码")
  private String cityCode;
  /**
   * 区级编码
   */
  @ApiModelProperty("区级编码")
  private String districtCode;
  /**
   * 省级编码
   */
  @ApiModelProperty("省级编码")
  private String provinceCode;
  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  private String cityName;
  /**
   * 区名称
   */
  @ApiModelProperty("区名称")
  private String districtName;
  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  private String provinceName;
  /**
   * 工程名
   */
  @ApiModelProperty("工程名")
  private String projectName;
  /**
   * 注册地址
   */
  @ApiModelProperty("注册地址")
  private String registeredAddress;
  /**
   * 经度
   */
  @ApiModelProperty("经度")
  private BigDecimal longitude;
  /**
   * 纬度
   */
  @ApiModelProperty("纬度")
  private BigDecimal latitude;
  /**
   * 客户联系方式
   */
  @ApiModelProperty("客户联系方式")
  private String customerContact;
  /**
   * 客户法人代表
   */
  @ApiModelProperty("客户法人代表")
  private String legalRepresentative;
  /**
   * erp编码
   */
  @ApiModelProperty("erp编码")
  private String erpCode;
  /**
   * 审批状态
   */
  @ApiModelProperty("审批状态")
  private String actApproveStatus;
  /**
   * 价格组
   */
  @ApiModelProperty("价格组")
  private String priceGroup;
  /**
   * 对接人列表
   */
  @ApiModelProperty("对接人列表")
  private List<CustomerDockingVo> dockingList;
  /**
   * 联系人列表
   */
  @ApiModelProperty("联系人列表")
  private List<CustomerContactVo> contactList;
  /**
   * 销售区域列表
   */
  @ApiModelProperty("销售区域列表")
  private List<CustomerSaleAreaVo> saleAreaList;
  /**
   * 客户开票信息
   */
  @ApiModelProperty("客户开票信息")
  private List<CustomerBillVo> billList;
  /**
   * 合作状态
   */
  @ApiModelProperty("合作状态")
  private String cooperateStatus;
  /**
   * 审批类型
   */
  @ApiModelProperty("审批类型")
  private String approvalType;
  /**
   * 流程编号
   */
  @ApiModelProperty("流程编号")
  private String processCode;
  /**
   * 业务来源系统
   */
  @ApiModelProperty("业务来源系统")
  private String fromType;
  /**
   * 证件上传照片/法人身份上传照片
   */
  @ApiModelProperty("证件上传照片/法人身份上传照片")
  private List<CustomerMediaVo> fileList;
  /**
   * 数据来源
   */
  @ApiModelProperty("数据来源")
  private String sourceType;
  /**
   * 企业组织
   */
  @ApiModelProperty("企业组织")
  private List<CustomerRelateOrgVo> orgList;

  @ApiModelProperty("锁定状态：009正常，003冻结")
  private String lockState;

  /**
   * 高德id
   */
  private String amapId;
}