package com.biz.crm.mdm.business.customer.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 客户收货地址分页dto
 *
 * @author ning.zhang
 * @date 2021/10/28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerAddressPageDto", description = "客户收货地址分页dto")
public class CustomerAddressPageDto extends TenantDto {

  /**
   * 联系人
   */
  @ApiModelProperty("联系人")
  private String contactName;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 是否默认地址(true：是，false：否)
   */
  @ApiModelProperty("是否默认地址(true：是，false：否)")
  private Boolean defaultAddress;
}
