package com.biz.crm.mdm.business.customer.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 客户开票信息Dto
 *
 * @author zxw
 * @date 2021-01-24 22:48:12
 */
@Data
@ApiModel(value = "CustomerBillDto", description = "客户开票信息Dto")
public class CustomerBillDto {

  /**
   * 开票单位
   */
  @ApiModelProperty("开票单位")
  private String billCompany;

  /**
   * 税号
   */
  @ApiModelProperty("税号")
  private String taxNumber;

  /**
   * 法人
   */
  @ApiModelProperty("法人")
  private String legal;

  /**
   * 开户银行
   */
  @ApiModelProperty("开户银行")
  private String depositBank;

  /**
   * 银行帐号
   */
  @ApiModelProperty("银行帐号")
  private String bankAccount;

  /**
   * 是否是默认开票信息，1是0否
   */
  @ApiModelProperty("是否是默认开票信息(true:是,false:否)")
  private Boolean billMain;

}