package com.biz.crm.mdm.business.customer.sdk.dto;

import com.biz.crm.business.common.sdk.dto.WorkflowFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 客户信息下拉框查询Dto
 *
 * @author ning.zhang
 * @date 2021/10/27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "CustomerSelectDto", description = "客户信息下拉框查询Dto")
public class CustomerSelectDto extends WorkflowFlagOpDto {

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;
  /**
   * 用于下拉列表选择,输入回显编码集合，字符串数组，一般用于多选" +
   * "，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据
   */
  @ApiModelProperty("用于下拉列表选择,输入回显编码集合，字符串数组，一般用于多选" +
      "，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
  private List<String> selectedCodes;

  /**
   * 编码名称模糊查询
   */
  @ApiModelProperty("编码名称模糊查询")
  private String keyword;

  /**
   * 流程状态
   */
  @ApiModelProperty("流程状态")
  private String processStatus;
}
