package com.biz.crm.mdm.business.customer.sdk.event;

import com.biz.crm.mdm.business.customer.sdk.dto.CustomerEventDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerSingleEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;


/**
 * 客户信息业务日志事件监听器
 *
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年05月23日 16:49:00
 */
public interface  CustomerLogEventListener extends NebulaEvent {

  /**
   * 创建事件
   */
  void onCreate(CustomerEventDto eventDto);

  /**
   * 删除事件
   *
   * @param eventDto
   */
  void onDelete(CustomerEventDto eventDto);

  /**
   * 更新日志
   *
   * @param eventDto
   */
  void onUpdate(CustomerEventDto eventDto);

  /**
   * 单个字段更新
   *
   * @param eventDto
   */
  void onSingleUpdate(CustomerSingleEventDto eventDto);

}