package com.biz.crm.mdm.business.customer.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 客户收货地址Vo
 *
 * @author ning.zhang
 * @date 2021/10/28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerAddressVo", description = "客户收货地址Vo")
public class CustomerAddressVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 7228210817672447201L;
  /**
   * 市级编码
   */
  @ApiModelProperty("市级编码")
  private String cityCode;
  /**
   * 区级编码
   */
  @ApiModelProperty("区级编码")
  private String districtCode;
  /**
   * 省级编码
   */
  @ApiModelProperty("省级编码")
  private String provinceCode;
  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  private String cityName;
  /**
   * 区名称
   */
  @ApiModelProperty("区名称")
  private String districtName;
  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  private String provinceName;
  /**
   * 详细地址
   */
  @ApiModelProperty("详细地址")
  private String detailedAddress;
  /**
   * 送达方编码
   */
  @ApiModelProperty("送达方编码")
  private String destinationCode;
  /**
   * 送达方名称
   */
  @ApiModelProperty("送达方名称")
  private String destinationName;
  /**
   * 联系人
   */
  @ApiModelProperty("联系人")
  private String contactName;
  /**
   * 联系电话
   */
  @ApiModelProperty("联系电话")
  private String contactPhone;
  /**
   * 是否默认地址(true：是，false：否)
   */
  @ApiModelProperty("是否默认地址(true：是，false：否)")
  private Boolean defaultAddress;
  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;
  /**
   * 有效开始时间
   */
  @ApiModelProperty("有效开始时间")
  private String startTime;
  /**
   * 有效结束时间
   */
  @ApiModelProperty("有效结束时间")
  private String endTime;

}