package com.biz.crm.mdm.business.customer.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 客户收货地址查询dto
 *
 * @author ning.zhang
 * @date 2022/4/24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerAddressQueryDto", description = "客户收货地址查询dto")
public class CustomerAddressQueryDto extends TenantDto {

  /**
   * 是否默认地址(true：是，false：否)
   */
  @ApiModelProperty("是否默认地址(true：是，false：否)")
  private Boolean defaultAddress;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

}