package com.biz.crm.mdm.business.customer.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 经销商客户信息dto
 *
 * @author songjingen
 */
@EqualsAndHashCode(callSuper = false)
@Data
@ApiModel(value = "CustomerClientDto", description = "经销商客户信息dto")
public class CustomerClientDto {
  /**
   * 企业用户账号
   */
  @ApiModelProperty(value = "企业用户账号", required = true)
  private String userName;

  /**
   * 租户编码
   */
  @ApiModelProperty(value = "租户编码", required = true)
  private String tenantCode;

  /**
   * 客户编码
   */
  @ApiModelProperty(value = "客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty(value = "客户名称")
  private String customerName;

  /**
   * 关键字
   */
  @ApiModelProperty("关键字（客户 编码）")
  private String keyWord;

  /**
   * 审批状态
   */
  @ApiModelProperty("审批状态")
  private String processStatus;

  /**
   * 客户类型
   */
  @ApiModelProperty("客户类型")
  private String customerType;

  /**
   * 排除客户编码集合
   */
  @ApiModelProperty("排除客户编码集合")
  private List<String> excludeCustomerCodes;
}