package com.biz.crm.mdm.business.customer.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.vo.AttachmentVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;

/**
 * 客户信息Dto
 *
 * @author ning.zhang
 * @date 2021/10/25
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CustomerDto", description = "客户信息Dto")
public class CustomerDto extends TenantFlagOpDto {

  /**
   * 工作流参数
   */
  @ApiModelProperty("工作流参数")
  private ProcessBusinessDto processBusiness;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channel;
  /**
   * 渠道名称
   */
  @ApiModelProperty("渠道名称")
  private String channelName;
  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;
  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;
  /**
   * 所属客户组织编码
   */
  @ApiModelProperty("所属客户组织编码")
  private String customerOrgCode;
  /**
   * 客户类型
   */
  @ApiModelProperty("客户类型")
  private String customerType;
  /**
   * 操作类型
   */
  @ApiModelProperty("操作类型")
  private String operateType;
  /**
   * 所属企业组织编码(多个逗号分隔)
   */
  @ApiModelProperty("所属企业组织编码(多个逗号分隔)")
  private String orgCode;
  /**
   * 市级编码
   */
  @ApiModelProperty("市级编码")
  private String cityCode;
  /**
   * 区级编码
   */
  @ApiModelProperty("区级编码")
  private String districtCode;
  /**
   * 省级编码
   */
  @ApiModelProperty("省级编码")
  private String provinceCode;
  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  private String cityName;
  /**
   * 区名称
   */
  @ApiModelProperty("区名称")
  private String districtName;
  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  private String provinceName;
  /**
   * 工程名
   */
  @ApiModelProperty("工程名")
  private String projectName;
  /**
   * 注册地址
   */
  @ApiModelProperty("注册地址")
  private String registeredAddress;
  /**
   * 经度
   */
  @ApiModelProperty("经度")
  private BigDecimal longitude;
  /**
   * 纬度
   */
  @ApiModelProperty("纬度")
  private BigDecimal latitude;
  /**
   * 客户联系方式
   */
  @ApiModelProperty("客户联系方式")
  private String customerContact;
  /**
   * 客户法人代表
   */
  @ApiModelProperty("客户法人代表")
  private String legalRepresentative;
  /**
   * erp编码
   */
  @ApiModelProperty("erp编码")
  private String erpCode;
  /**
   * 审批状态
   */
  @ApiModelProperty("审批状态")
  private String actApproveStatus;
  /**
   * 价格组
   */
  @ApiModelProperty("价格组")
  private String priceGroup;
  /**
   * 是否分利 true/false
   */
  @ApiModelProperty("是否分利")
  private Boolean shareBenefits;
  /**
   * 经销商编码集合
   */
  @ApiModelProperty("经销商编码集合")
  private List<String> customerCodeList;

  /**
   * 对接人列表
   */
  @ApiModelProperty("对接人列表")
  private List<CustomerDockingDto> dockingList;
  /**
   * 联系人列表
   */
  @ApiModelProperty("联系人列表")
  private List<CustomerContactDto> contactList;
  /**
   * 销售区域列表
   */
  @ApiModelProperty("销售区域列表")
  private List<CustomerSaleAreaDto> saleAreaList;
  /**
   * 客户开票信息
   */
  @ApiModelProperty("客户开票信息")
  private List<CustomerBillDto> billList;
  /**
   * 合作状态
   */
  @ApiModelProperty("合作状态")
  private String cooperateStatus;
  /**
   * 审批类型
   */
  @ApiModelProperty("审批类型")
  private String approvalType;
  /**
   * 流程编号
   */
  @ApiModelProperty("流程编号")
  private String processCode;
  /**
   * 业务来源系统
   */
  @ApiModelProperty("业务来源系统")
  private String fromType;
  /**
   * 证件上传照片/法人身份上传照片
   */
  @ApiModelProperty("证件上传照片/法人身份上传照片")
  private List<CustomerUploadDto> fileList;
  /**
   * 数据来源
   */
  @ApiModelProperty("数据来源")
  private String sourceType;

  /**
   * 客户等级
   */
  @ApiModelProperty("客户等级")
  private String customerLevel;

  /**
   * 上级经销商编码
   */
  @ApiModelProperty("上级经销商编码")
  private String parentCustomerCode;

  /**
   * 流程附件信息
   */
  @ApiModelProperty(value = "流程附件信息")
  private List<AttachmentVo> attachmentVos;

  /**
   * 是否提交审批流程(true:是,false:否)
   */
  @ApiModelProperty("是否提交审批流程(true:是,false:否)")
  private Boolean submitProcess;

  @ApiModelProperty(value ="经销商id（EAS）")
  private String sourcesId;

  @ApiModelProperty(value ="经销商id（兆信）")
  private String dealerId;

  @ApiModelProperty(value ="经销商渠道类型")
  private String dealerType;

  @ApiModelProperty(value ="经销商分类id")
  private String dealerClassifyId;

  @ApiModelProperty(value ="经销商分类名称")
  private String dealerClassifyName;

  @ApiModelProperty(value ="签约类型")
  private String signType;

  @ApiModelProperty(value ="经销商等级id")
  private String dealerLevelId;

  @ApiModelProperty(value ="经销商等级名称")
  private String DealerLevelName;

  @ApiModelProperty(value ="联系人")
  private String contactName;

  @ApiModelProperty(value ="电话")
  private String phone;

  @ApiModelProperty(value ="经销商身份")
  private String channelLevel;

  @ApiModelProperty(value ="状态")
  private String status;

  @ApiModelProperty(value ="省")
  private String province;

  @ApiModelProperty(value ="市")
  private String city;

  @ApiModelProperty(value ="县区/市县")
  private String district;

  @ApiModelProperty(value ="详细地址")
  private String addressDetail;

  /**
   * 经销商与组织关系集合
   */
//  @ApiModelProperty(value ="经销商与组织关系集合")
//  List<DealerOrgRelationshipDto> dealerOrgRelationshipDtos;

  /**
   * 采供关系集合
   */
  @ApiModelProperty(value ="采供关系集合")
  List<SupplyRelationshipDto> supplyRelationshipDtos;

  @ApiModelProperty(value ="渠道类型")
  @Column(name = "channel_type", length = 10, columnDefinition = "VARCHAR(10) COMMENT '渠道类型'")
  private String channelType;

  @ApiModelProperty(value ="渠道分类")
  @Column(name = "channel_category", length = 10, columnDefinition = "VARCHAR(10) COMMENT '渠道分类'")
  private String channelCategory;

  @ApiModelProperty(value ="渠道等级")
  @Column(name = "channel_level_code", length = 10, columnDefinition = "VARCHAR(10) COMMENT '渠道等级'")
  private String channelLevelCode;

  @ApiModelProperty(value = "经销商销售区域")
  private String areaType;

  @ApiModelProperty(value ="助记码")
  private String mnemonicCode;

  @ApiModelProperty(value = "经销商关联销售区域dto")
  private List<DealerSalesRegionDto> dealerSalesRegionDtoList;

  @ApiModelProperty(value = "经销商组织关系关联dto")
  private List<CustomerROrgDto> customerROrgDtoList;

}