package com.biz.crm.mdm.business.customer.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 客户标签dto
 *
 * @author yangshan
 * @date 2021-3-4 11:42:04
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerTagDto", description = "客户标签dto" )
public class CustomerTagDto extends TenantDto {

    /**
     * 标签名称
     */
    @ApiModelProperty("标签名称")
    private String tagName;

    @ApiModelProperty("标签类型")
    private String tagType;

    /**
     * 标签说明
     */
    @ApiModelProperty("标签说明")
    private String tagDescription;

    /**
     * 更新方式（0：实时更新；1：定时更新）
     */
    @ApiModelProperty("更新方式（0：实时更新；1：定时更新）")
    private Boolean updateType ;

    /**
     * 更新周期（day：天；week：周；month：月；year：年）
     */
    @ApiModelProperty("更新周期（day：天；week：周；month：月；year：年）")
    private String updateCycle ;

    /**
     * 经销商编码
     */
    @ApiModelProperty("经销商编码")
    private String customerCode;

    /**
     * 规则信息
     */
    @ApiModelProperty("规则信息")
    private List<CustomerTagRuleDto> rules;
}