package com.biz.crm.mdm.business.customer.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName DealerSalesRegionReqVo
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/14 10:51
 **/
@Data
@ApiModel("经销商销售区域")
public class DealerSalesRegionDto extends TenantFlagOpDto {

    @ApiModelProperty(value = "经销商id（EAS）")
    private String sourcesId;

    @ApiModelProperty(value = "经销商id（兆信）")
    private String dealerId;

    @ApiModelProperty(value = "经销商编码")
    private String dealerCode;

    @ApiModelProperty(value = "经销商名称")
    private String dealerName;

    @ApiModelProperty(value = "经销区域类型")
    private String areaType;

    @ApiModelProperty(value = "经销范围（省）")
    private String province;

    @ApiModelProperty(value = "经销范围（市）")
    private String city;

    @ApiModelProperty(value = "经销范围（区县/市区）")
    private String district;

    @ApiModelProperty(value = "经销范围（乡镇/街道）")
    private String town;

    @ApiModelProperty(value = "省名字")
    private String provinceName;

    @ApiModelProperty(value = "市名字")
    private String cityName;

    @ApiModelProperty(value = "区名字")
    private String districtName;

    @ApiModelProperty(value = "乡镇名字")
    private String townName;

}
