package com.biz.crm.mdm.business.customer.sdk.service;

import com.biz.crm.mdm.business.customer.sdk.vo.DealerOrgRelationshipVo;

import java.util.List;
import java.util.Map;

/**
 * @ClassName DealerOrgRelationshipService
 * @Description TODO
 * @AUTHOR WangJJ
 * @DATE 2023/6/19 10:02
 **/
public interface DealerOrgRelationshipService {

    /**
     *  根据经销商编码集合获取经销商组织信息
     * @param dealerCodes 经销商编码集合
     * @return
     */
    List<DealerOrgRelationshipVo> listByDealerCodes(List<String> dealerCodes);

    /**
     * 根据经销商编码集合获取经销商组织Map信息
     * @param dealerIds 经销商ID(兆信)集合
     * @return Map<String,List<DealerOrgRelationshipVo>  Map<经销商ID(兆信),关联组织关系集合>
     */
    Map<String,List<DealerOrgRelationshipVo>> findDealerOrgRelationshipMap(List<String> dealerIds);


}
