package com.biz.crm.mdm.business.customer.sdk.service;

import com.biz.crm.mdm.business.customer.sdk.dto.SupplyRelationshipDto;
import com.biz.crm.mdm.business.customer.sdk.vo.SupplyRelationshipVo;

import java.util.List;
import java.util.Map;

/**
 * @ClassName SupplyRelationshipSdkService
 * @Description 采供关系接口
 * @AUTHOR WangJJ
 * @DATE 2023/6/15 14:16
 **/
public interface SupplyRelationshipSdkService {

    /**
     * 供货关系新增
     * @param dtos
     * @param buyerId 采购方ID（兆信）
     * @return
     */
    void savaOrUpdate(List<SupplyRelationshipDto> dtos, String buyerId);

    /**
     * 根据ID获取明细
     * @param buyerId
     * @return
     */
    List<SupplyRelationshipVo> findByBuyerId(String buyerId);

    /**
     * 根据ID获取明细
     * @param buyerIds
     * @return
     */
    Map<String,List<SupplyRelationshipVo>> findByBuyerIds(List<String> buyerIds);

}
