package com.biz.crm.mdm.business.customer.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 客户信息对接人Vo
 *
 * @author ning.zhang
 * @date 2021/10/25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerDockingVo", description = "客户信息对接人Vo")
public class CustomerDockingVo extends TenantVo {

  private static final long serialVersionUID = 6271731219893465628L;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String positionCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String positionName;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channel;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 联系方式
   */
  @ApiModelProperty("联系方式")
  private String contact;

  /**
   * 用户帐号
   */
  @ApiModelProperty("用户帐号")
  private String userName;

  /**
   * 用户名称
   */
  @ApiModelProperty("用户名称")
  private String fullName;

  /**
   * 销售公司编码
   */
  @ApiModelProperty("销售公司编码")
  private String saleCompany;

  /**
   * 对接人供货关系列表
   */
  @ApiModelProperty("对接人供货关系列表")
  private List<CustomerDockingSupplyVo> mdmCustomerSupplyDetailList;

}