package com.biz.crm.mdm.business.customer.sdk.vo;

import com.bizunited.nebula.common.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 客户与企业组织关联表实体类
 *
 * @author ning.zhang
 * @date 2021/11/10
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerROrgEntity", description = "客户与企业组织关联表实体类")
public class CustomerROrgVo extends TenantVo {


  private static final long serialVersionUID = -4535359817780910274L;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 企业组织编码
   */
  @ApiModelProperty("企业组织编码")
  private String orgCode;

  @ApiModelProperty(value = "关联组织id（EAS）")
  private String sourcesOrgId;

  @ApiModelProperty(value = "关联组织id(兆信)")
  private String relationOrgId;

  @ApiModelProperty(value = "关联组织编码")
  private String relationOrgCode;

  @ApiModelProperty(value = "关联组织名称")
  private String relationOrgName;

  @ApiModelProperty(value = "状态")
  private String status;

  @ApiModelProperty(value = "经销商id（EAS）")
  private String sourcesId;
  @ApiModelProperty(value = "经销商id（兆信）")
  private String dealerId;

  @ApiModelProperty(value = "经销商编码")
  private String dealerCode;

  @ApiModelProperty(value = "经销商名称")
  private String dealerName;

}
