package com.biz.crm.mdm.business.customer.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 客户信息销售区域Vo
 *
 * @author ning.zhang
 * @date 2021/10/25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerSaleAreaVo", description = "客户信息销售区域Vo")
public class CustomerSaleAreaVo extends TenantVo {

  private static final long serialVersionUID = -4026914942228885711L;

  /**
   * 一级区域
   */
  @ApiModelProperty("一级区域")
  private String areaOne;
  /**
   * 一级区域名称
   */
  @ApiModelProperty("一级区域名称")
  private String areaOneName;
  /**
   * 二级区域
   */
  @ApiModelProperty("二级区域")
  private String areaTwo;
  /**
   * 二级区域名称
   */
  @ApiModelProperty("二级区域名称")
  private String areaTwoName;
  /**
   * 三级区域名称
   */
  @ApiModelProperty("三级区域")
  private String areaThree;
  /**
   * 三级区域
   */
  @ApiModelProperty("三级区域名称")
  private String areaThreeName;
}