package com.biz.crm.mdm.business.customer.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @ClassName DealerSupplyRelationshipReqVo
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/13 16:26
 **/
@Data
@ApiModel("采供信息同步表")
public class SupplyRelationshipVo extends TenantFlagOpVo {

    @ApiModelProperty(value = "供货组织id")
    private String supplierOrgId;

    @ApiModelProperty(value = "供货组织编码")
    private String supplierOrgCode;

    @ApiModelProperty(value = "供货组织名称")
    private String supplierOrgName;

    @ApiModelProperty(value = "供货单位编码")
    private String supplierCode;

    @ApiModelProperty(value = "供货单位名称")
    private String supplierName;

    @ApiModelProperty(value = "供货单位id（EAS）")
    private String supplierSourceId;

    @ApiModelProperty(value = "供货单位id（兆信）")
    private String supplierId;

    @ApiModelProperty(value = "供货单位类型")
    private String supplierType;

    @ApiModelProperty(value = "采购单位id（EAS）")
    private String buyerSourceId;

    @ApiModelProperty(value = "采购单位id（兆信）")
    private String buyerId;

    @ApiModelProperty(value = "采购单位编码")
    private String buyerCode;

    @ApiModelProperty(value = "采购单位名称")
    private String buyerName;

    @ApiModelProperty(value = "采购商类型")
    private String buyerType;

    @ApiModelProperty(value = "采购商小类型")
    private String buyerSmallType;

    @ApiModelProperty(value = "采购商分类")
    private String buyerClassify;

    @ApiModelProperty(value = "采购商品数量")
    private Integer buyNum;

    @ApiModelProperty(value = "状态")
    private String status;

    @ApiModelProperty(value = "采供明细集合")
    private List<SupplyRelationshipDetailVo> detailVos;

}
