package com.biz.crm.mdm.business.customer.user.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.user.feign.feign.internal.CustomerUserRelateCustomerVoFeignImpl;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserRelateCustomerVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 客户用户与客户签证官假装
 *
 * @author hefan
 * @date 2022/07/13
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = CustomerUserRelateCustomerVoFeignImpl.class)
public interface CustomerUserRelateCustomerVoFeign {

  /**
   * 根据客户编码集合获取对应的客户用户关联信息集合
   *
   * @param customerCodeList 客户代码列表
   * @return {@link Result}<{@link List}<{@link CustomerUserRelateCustomerVo}>>
   */
  @ApiOperation(value = "根据客户编码集合获取对应的客户用户关联信息集合")
  @GetMapping(value = {"/v1/customerUser/customerUserRelaCustomer/findByCustomerCodes"})
  Result<List<CustomerUserRelateCustomerVo>> findByCustomerCodes(@RequestParam("customerCodeList") List<String> customerCodeList);
}
