package com.biz.crm.mdm.business.customer.user.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.user.feign.feign.internal.CustomerUserVoServiceFeignImpl;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Project crm-ems
 * @PackageName com.biz.crm.ems.feign.customer.local.feign
 * @ClassName MdmCustomerUserVoServiceFeign
 * @Author YangWei
 * @Date 2022/3/14 上午10:40
 * @Description mdm经销商用户feign
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = CustomerUserVoServiceFeignImpl.class)
public interface CustomerUserVoServiceFeign {

  /**
   * 根据用户名查询
   * @param userName
   * @return
   */
  @GetMapping("/v1/customerUser/customerUser/findByUserName")
  Result<CustomerUserVo> findByUserName(@RequestParam("userName") String userName);

  /**
   * 通过用户手机号获取客户用户信息(包含经客户信息)
   *
   * @param userPhone 用户手机号
   * @return
   */
  @ApiOperation(value = "通过用户手机号获取客户用户信息(包含经客户信息)")
  @GetMapping("/v1/customerUser/customerUser/findDetailsByUserPhone")
  public Result<CustomerUserVo> findDetailsByUserPhone(@RequestParam("userPhone") String userPhone);

}