package com.biz.crm.mdm.business.customer.user.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.user.feign.feign.CustomerUserRelateCustomerVoFeign;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserRelateCustomerVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 客户用户与客户签证官假装impl
 *
 * @author hefan
 * @date 2022/07/13
 */
@Slf4j
@Component
public class CustomerUserRelateCustomerVoFeignImpl implements FallbackFactory<CustomerUserRelateCustomerVoFeign> {
  @Override
  public CustomerUserRelateCustomerVoFeign create(Throwable throwable) {
    return new CustomerUserRelateCustomerVoFeign(){

      @Override
      public Result<List<CustomerUserRelateCustomerVo>> findByCustomerCodes(List<String> customerCodeList) {
        throw new UnsupportedOperationException("根据客户编码集合查询客户用户——熔断");
      }
    };
  }
}
