package com.biz.crm.mdm.business.customer.user.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.user.feign.feign.CustomerUserVoServiceFeign;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @Project crm-ems
 * @PackageName com.biz.crm.ems.feign.customer.local.feign.internal
 * @ClassName MdmCustomerUserVoServiceFeignImpl
 * @Author YangWei
 * @Date 2022/3/14 上午10:41
 * @Description mdm经销商客户feign熔断
 */
@Slf4j
@Component
public class CustomerUserVoServiceFeignImpl implements FallbackFactory<CustomerUserVoServiceFeign> {
  @Override
  public CustomerUserVoServiceFeign create(Throwable throwable) {
    return new CustomerUserVoServiceFeign() {
      @Override
      public Result<CustomerUserVo> findByUserName(String userName) {
        log.info("请求MDM用户信息熔断:{}",throwable.getMessage());
        return null;
      }

      @Override
      public Result<CustomerUserVo> findDetailsByUserPhone(String userPhone) {
        throw new UnsupportedOperationException("通过用户手机号获取客户用户信息(包含经客户信息)熔断");
      }
    };
  }
}