package com.biz.crm.mdm.business.customer.user.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.user.local.entity.CustomerUser;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserPaginationDto;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserResetPasswordDto;
import java.util.Set;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 客户用户(CustomerUser)表服务接口
 *
 * @author sunx
 * @since 2021-10-20 16:35:05
 */
public interface CustomerUserService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<CustomerUser> findByConditions(Pageable pageable, CustomerUserPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  CustomerUser findDetailById(String id);

  /**
   * 创建
   *
   * @param customerUser
   * @return
   */
  CustomerUser create(CustomerUser customerUser);

  /**
   * 更新
   *
   * @param customerUser
   * @return
   */
  CustomerUser update(CustomerUser customerUser);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 根据id或编码获取集合
   *
   * @param ids
   * @param userCodes
   * @return
   */
  List<CustomerUser> findDetailsByIdsOrUserCodes(List<String> ids, List<String> userCodes);

  /**
   * 重置密码
   *
   * @param dto
   */
  void resetPassword(CustomerUserResetPasswordDto dto);

  /**
   * 根据角色及租户编码获取匹配数据集合
   *
   * @param roleCodeList
   * @param tenantCode
   * @return
   */
  List<CustomerUser> findByRoleCodesAndTenantCode(List<String> roleCodeList, String tenantCode);

  /**
   * 根据角色及租户编码获取匹配数据集合
   *
   * @param codeList
   * @param tenantCode
   * @return
   */
  List<CustomerUser> findByCustomerCodes(List<String> codeList, String tenantCode);

  /**
   * 根据用户名查询
   * @param userName
   * @return
   */
  CustomerUser findByUserName(String userName);

  /**
   * 根据用户名查询（结合新增功能来看，手机号不会重复）
   * @param phone
   * @return
   */
  CustomerUser findByPhone(String phone);

  /**
   * 通过用户手机号获取客户用户信息
   *
   * @param userPhone  用户手机号
   * @param tenantCode
   * @return
   */
  List<CustomerUser> findByUserPhone(String userPhone, String tenantCode);

  /**
   * 根据用户账号集合获取用户信息
   *
   * @param userNameSet
   * @return
   */
  List<CustomerUser> findByUserNames(Set<String> userNameSet);
}
