package com.biz.crm.mdm.business.customer.user.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserDto;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserResetPasswordDto;
import com.biz.crm.mdm.business.customer.user.sdk.service.CustomerUserVoService;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;

/**
 * 客户用户控制层
 *
 * @author sunx
 * @since 2021-10-20 16:35:06
 */
@Slf4j
@Api(tags = "客户用户: CustomerUserVo: 客户用户")
@RestController
@RequestMapping(value = {"/v1/customerUser/customerUser"})
public class CustomerUserVoController {

  @Autowired(required = false)
  private CustomerUserVoService customerUserVoService;

  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<CustomerUserVo> findDetailById(@RequestParam("id") String id) {
    List<String> ids = Lists.newLinkedList();
    if (StringUtils.isNotBlank(id)) {
      ids.add(id);
    }
    try {
      CustomerUserVo vo = null;
      List<CustomerUserVo> list = customerUserVoService.findDetailsByIdsOrUserCodes(ids, null);
      Optional<CustomerUserVo> optional = list.stream().findFirst();
      if (optional.isPresent()) {
        vo = optional.get();
      }
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<CustomerUserVo> create(@RequestBody CustomerUserDto dto) {
    try {
      CustomerUserVo vo = this.customerUserVoService.create(dto);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<CustomerUserVo> update(@RequestBody CustomerUserDto dto) {
    try {
      CustomerUserVo vo = this.customerUserVoService.update(dto);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "重置密码")
  @PostMapping("/updatePasswordByIds")
  public Result<?> updatePasswordByIds(@RequestBody CustomerUserResetPasswordDto dto) {
    try {
      this.customerUserVoService.updatePasswordByIds(dto);
      return Result.ok("修改成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据登录账号查询用户信息
   * @param userName
   * @return
   */
  @ApiOperation(value = "根据登录账号查询用户信息")
  @GetMapping(value = {"/findByUserName"})
  public Result<CustomerUserVo> findByUserName(@RequestParam("userName") String userName){
    try {
      log.info("根据用户账号查询详情:{}",userName);
      CustomerUserVo vo = this.customerUserVoService.findByUserName(userName);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据手机号查询用户信息
   * @param phone
   * @return
   */
  @ApiOperation(value = "根据手机号查询用户信息")
  @GetMapping(value = {"/findByPhone"})
  public Result<CustomerUserVo> findByPhone(@RequestParam("phone") String phone){
    try {
      log.info("根据手机号查询详情:{}",phone);
      CustomerUserVo vo = this.customerUserVoService.findByPhone(phone);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过用户手机号获取客户用户信息(包含经客户信息)
   *
   * @param userPhone 用户手机号
   * @return
   */
  @ApiOperation(value = "通过用户手机号获取客户用户信息(包含经客户信息)")
  @GetMapping(value = {"/findDetailsByUserPhone"})
  public Result<CustomerUserVo> findDetailsByUserPhone(@RequestParam("userPhone") String userPhone) {
    try {
      return Result.ok(this.customerUserVoService.findDetailsByUserPhone(userPhone));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
