package com.biz.crm.mdm.business.customer.user.local.service.internal;

import com.biz.crm.mdm.business.customer.user.local.repository.CustomerUserRepository;
import com.biz.crm.mdm.business.customer.user.sdk.service.CustomerUserRelateCustomerVoService;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserRelateCustomerVo;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author sunx
 * @date 2021/11/25
 */
@Service
public class CustomerUserRelateCustomerVoServiceImpl
    implements CustomerUserRelateCustomerVoService {

  @Autowired(required = false) private CustomerUserRepository customerUserRepository;

  @Override
  public List<CustomerUserRelateCustomerVo> findByCustomerCodes(List<String> customerCodeList) {
    if (CollectionUtils.isEmpty(customerCodeList)) {
      return Lists.newLinkedList();
    }
    return this.customerUserRepository.findRelateCustomerByCustomerCodes(customerCodeList);
  }
}
