/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.user.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserDto;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserResetPasswordDto;
import com.biz.crm.mdm.business.customer.user.sdk.service.CustomerUserVoService;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5ba2\u6237\u7528\u6237: CustomerUserVo: \u5ba2\u6237\u7528\u6237"})
@RestController
@RequestMapping(value={"/v1/customerUser/customerUser"})
public class CustomerUserVoController {
    private static final Logger log = LoggerFactory.getLogger(CustomerUserVoController.class);
    @Autowired(required=false)
    private CustomerUserVoService customerUserVoService;

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<CustomerUserVo> findDetailById(@RequestParam(value="id") String id) {
        LinkedList ids = Lists.newLinkedList();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            ids.add(id);
        }
        try {
            CustomerUserVo vo = null;
            List list = this.customerUserVoService.findDetailsByIdsOrUserCodes((List)ids, null);
            Optional optional = list.stream().findFirst();
            if (optional.isPresent()) {
                vo = (CustomerUserVo)optional.get();
            }
            return Result.ok(vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<CustomerUserVo> create(@RequestBody CustomerUserDto dto) {
        try {
            CustomerUserVo vo = this.customerUserVoService.create(dto);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<CustomerUserVo> update(@RequestBody CustomerUserDto dto) {
        try {
            CustomerUserVo vo = this.customerUserVoService.update(dto);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801")
    @PostMapping(value={"/updatePasswordByIds"})
    public Result<?> updatePasswordByIds(@RequestBody CustomerUserResetPasswordDto dto) {
        try {
            this.customerUserVoService.updatePasswordByIds(dto);
            return Result.ok((String)"\u4fee\u6539\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u767b\u5f55\u8d26\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/findByUserName"})
    public Result<CustomerUserVo> findByUserName(@RequestParam(value="userName") String userName) {
        try {
            log.info("\u6839\u636e\u7528\u6237\u8d26\u53f7\u67e5\u8be2\u8be6\u60c5:{}", (Object)userName);
            CustomerUserVo vo = this.customerUserVoService.findByUserName(userName);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/findByPhone"})
    public Result<CustomerUserVo> findByPhone(@RequestParam(value="phone") String phone) {
        try {
            log.info("\u6839\u636e\u624b\u673a\u53f7\u67e5\u8be2\u8be6\u60c5:{}", (Object)phone);
            CustomerUserVo vo = this.customerUserVoService.findByPhone(phone);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7528\u6237\u624b\u673a\u53f7\u83b7\u53d6\u5ba2\u6237\u7528\u6237\u4fe1\u606f(\u5305\u542b\u7ecf\u5ba2\u6237\u4fe1\u606f)")
    @GetMapping(value={"/findDetailsByUserPhone"})
    public Result<CustomerUserVo> findDetailsByUserPhone(@RequestParam(value="userPhone") String userPhone) {
        try {
            return Result.ok((Object)this.customerUserVoService.findDetailsByUserPhone(userPhone));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

