/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.user.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.user.local.entity.CustomerUser;
import com.biz.crm.mdm.business.customer.user.local.mapper.CustomerUserMapper;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserPaginationDto;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserResetPasswordDto;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserRelateCustomerVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class CustomerUserRepository
extends ServiceImpl<CustomerUserMapper, CustomerUser> {
    public Page<CustomerUser> findByConditions(Page<CustomerUser> page, CustomerUserPaginationDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((CustomerUserMapper)this.baseMapper).findByConditions(page, dto);
    }

    public CustomerUser findById(String id) {
        return (CustomerUser)((Object)((CustomerUserMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public List<CustomerUser> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public List<CustomerUser> findByUserCodes(List<String> userCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(CustomerUser::getUserCode, userCodes)).list();
    }

    public List<CustomerUser> findDetailsByIdsOrUserCodes(List<String> ids, List<String> userCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.in(CollectionUtils.isNotEmpty((Collection)ids), UuidEntity::getId, (Collection)ids)).or()).in(CollectionUtils.isNotEmpty((Collection)userCodes), CustomerUser::getUserCode, (Collection)userCodes);
        })).list();
    }

    public Integer countByUserCode(String userCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(CustomerUser::getUserCode, (Object)userCode)).count();
    }

    public void resetPassword(CustomerUserResetPasswordDto dto) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, (Collection)dto.getIds())).set(CustomerUser::getUserPassword, (Object)dto.getPassword())).set(CustomerUser::getUpdatePasswordDate, (Object)new Date())).update();
    }

    public List<CustomerUser> findByRoleCodesAndTenantCode(List<String> roleCodeList, String tenantCode) {
        return ((CustomerUserMapper)this.baseMapper).findByRoleCodesAndTenantCode(roleCodeList, tenantCode, DelFlagStatusEnum.NORMAL.getCode());
    }

    public List<CustomerUserRelateCustomerVo> findRelateCustomerByCustomerCodes(List<String> customerCodeList) {
        return ((CustomerUserMapper)this.baseMapper).findRelateCustomerByCustomerCodes(customerCodeList, TenantUtils.getTenantCode(), DelFlagStatusEnum.NORMAL.getCode());
    }

    public Integer countByUserName(String userName) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(CustomerUser::getUserName, (Object)userName)).count();
    }

    public CustomerUser findUserByPhone(String userPhone) {
        return (CustomerUser)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(CustomerUser::getUserPhone, (Object)userPhone)).one());
    }

    public List<CustomerUser> findByCustomerCodes(List<String> codeList, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(CustomerUser::getUserCode, codeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public CustomerUser findByUserName(String userName, String tenantCode) {
        return (CustomerUser)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(CustomerUser::getUserName, (Object)userName)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<CustomerUser> findByUserPhone(String userPhone, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(CustomerUser::getUserPhone, (Object)userPhone)).list();
    }

    public List<CustomerUser> findByUserNames(Set<String> userNameSet) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(CustomerUser::getUserName, userNameSet)).list();
    }

    public CustomerUser findByIdAndTenantCode(String id, String tenantCode) {
        return (CustomerUser)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }
}

