package com.biz.crm.mdm.business.customer.user.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.customer.user.local.entity.CustomerUserRelaCustomer;
import com.biz.crm.mdm.business.customer.user.local.mapper.CustomerUserRelaCustomerMapper;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserRelaCustomerVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 客户用户与客户关联客户表(repository)
 *
 * @author sunx
 * @since 2021-10-20 16:36:38
 */
@Component
public class CustomerUserRelaCustomerRepository
    extends ServiceImpl<CustomerUserRelaCustomerMapper, CustomerUserRelaCustomer> {

  public List<CustomerUserRelaCustomer> findByUserCodes(List<String> userCodeList) {
    return this.lambdaQuery()
        .eq(CustomerUserRelaCustomer::getTenantCode, TenantUtils.getTenantCode())
        .in(CustomerUserRelaCustomer::getUserCode, userCodeList)
        .list();
  }

  public void deleteByUserCodes(List<String> userCodeList) {
    LambdaQueryWrapper<CustomerUserRelaCustomer> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery
        .eq(CustomerUserRelaCustomer::getTenantCode, TenantUtils.getTenantCode())
        .in(CustomerUserRelaCustomer::getUserCode, userCodeList);
    baseMapper.delete(lambdaQuery);
  }

  public Integer countByCustomerCodes(List<String> customerCodeList) {
    return this.lambdaQuery()
        .eq(CustomerUserRelaCustomer::getTenantCode, TenantUtils.getTenantCode())
        .in(CustomerUserRelaCustomer::getCustomerCode, customerCodeList)
        .count();
  }

  /**
   * 根据客户编码集合查询客户用户与客户关联信息
   *
   * @param customerCodeList
   * @return
   */
  public List<CustomerUserRelaCustomer> findByCustomerCodes(List<String> customerCodeList) {
    return this.lambdaQuery()
        .eq(CustomerUserRelaCustomer::getTenantCode, TenantUtils.getTenantCode())
        .in(CustomerUserRelaCustomer::getCustomerCode, customerCodeList)
        .list();
  }

  /**
   * 查询关联客户
   * @param userCodeList
   * @return {@link List< CustomerUserRelaCustomerVo>}
   */
  public List<CustomerUserRelaCustomerVo> findCustomerUserRelaVoByUserCodes(List<String> userCodeList) {
    return this.baseMapper.findCustomerUserRelaVoByUserCodes(userCodeList,TenantUtils.getTenantCode());
  }
}
