package com.biz.crm.mdm.business.customer.user.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.customer.user.local.entity.CustomerUserRelaRole;
import com.biz.crm.mdm.business.customer.user.local.mapper.CustomerUserRelaRoleMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 客户用户关联角色(repository)
 *
 * @author sunx
 * @date 2021-11-01 09:30:12
 */
@Component
public class CustomerUserRelaRoleRepository
    extends ServiceImpl<CustomerUserRelaRoleMapper, CustomerUserRelaRole> {

  public List<CustomerUserRelaRole> findByUserCodes(List<String> userCodeList) {
    return this.lambdaQuery()
        .eq(CustomerUserRelaRole::getTenantCode, TenantUtils.getTenantCode())
        .in(CustomerUserRelaRole::getUserCode, userCodeList)
        .list();
  }

  public void deleteByUserCodes(List<String> userCodeList) {
    LambdaQueryWrapper<CustomerUserRelaRole> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery
        .eq(CustomerUserRelaRole::getTenantCode, TenantUtils.getTenantCode())
        .in(CustomerUserRelaRole::getUserCode, userCodeList);
    baseMapper.delete(lambdaQuery);
  }

  public List<CustomerUserRelaRole> findByRoleCodesAndTenantCode(
      List<String> roleCodeList, String tenantCode) {
    return this.lambdaQuery()
        .eq(CustomerUserRelaRole::getTenantCode, tenantCode)
        .in(CustomerUserRelaRole::getRoleCode, roleCodeList)
        .list();
  }

  public List<CustomerUserRelaRole> findByIds(List<String> idList) {
    return this.lambdaQuery()
        .eq(CustomerUserRelaRole::getTenantCode, TenantUtils.getTenantCode())
        .in(CustomerUserRelaRole::getId, idList)
        .list();
  }

  public List<CustomerUserRelaRole> findByUserCodesAndRoleCodes(
      List<String> customerUserCodeList, List<String> roleCodeList) {
    return this.lambdaQuery()
        .eq(CustomerUserRelaRole::getTenantCode, TenantUtils.getTenantCode())
        .in(CustomerUserRelaRole::getRoleCode, roleCodeList)
        .in(CustomerUserRelaRole::getUserCode, customerUserCodeList)
        .list();
  }
}
