package com.biz.crm.mdm.business.customer.user.local.service;

import com.biz.crm.mdm.business.customer.user.local.entity.CustomerUserRelaRole;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserRelaRoleBindDto;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserRelaRoleUnbindDto;
import java.util.List;

/**
 * 客户用户关联角色(CustomerUserRRole)表服务接口
 *
 * @author sunx
 * @date 2021-11-01 09:30:13
 */
public interface CustomerUserRelaRoleService {

  /**
   * 根据客户用户编码获取绑定的角色集合信息
   *
   * @param userCodeList
   * @return
   */
  List<CustomerUserRelaRole> findByUserCodes(List<String> userCodeList);

  /**
   * 批量保存关联角色
   *
   * @param roleList
   * @param userCode
   */
  void saveBatch(List<CustomerUserRelaRole> roleList, String userCode);

  /**
   * 根据角色编码获取关联的用户信息
   *
   * @param roleCodeList
   * @param tenantCode
   * @return
   */
  List<CustomerUserRelaRole> findByRoleCodesAndTenantCode(
      List<String> roleCodeList, String tenantCode);

  /**
   * 客户用户绑定角色
   *
   * @param dto
   */
  void bind(CustomerUserRelaRoleBindDto dto);

  /**
   * 客户用户解绑角色
   *
   * @param dto
   */
  void unbind(CustomerUserRelaRoleUnbindDto dto);
}
