/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.user.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.mdm.business.customer.user.local.entity.CustomerUserRelaRole;
import com.biz.crm.mdm.business.customer.user.local.repository.CustomerUserRelaRoleRepository;
import com.biz.crm.mdm.business.customer.user.local.service.CustomerUserRelaRoleService;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserRelaRoleBindDto;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserRelaRoleUnbindDto;
import com.biz.crm.mdm.business.customer.user.sdk.event.CustomerUserRelateRoleEventListener;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserRelaRoleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerUserRelaRoleService")
public class CustomerUserRelaRoleServiceImpl
implements CustomerUserRelaRoleService {
    @Autowired(required=false)
    private CustomerUserRelaRoleRepository customerUserRelaRoleRepository;
    @Autowired(required=false)
    @Lazy
    private List<CustomerUserRelateRoleEventListener> customerUserRelateRoleEventListeners;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public List<CustomerUserRelaRole> findByUserCodes(List<String> userCodeList) {
        if (CollectionUtils.isEmpty(userCodeList)) {
            return Lists.newLinkedList();
        }
        return this.customerUserRelaRoleRepository.findByUserCodes(userCodeList);
    }

    @Override
    @Transactional
    public void saveBatch(List<CustomerUserRelaRole> roleList, String userCode) {
        Validate.notBlank((CharSequence)userCode, (String)"\u5ba2\u6237\u7528\u6237\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.customerUserRelaRoleRepository.deleteByUserCodes(Lists.newArrayList((Object[])new String[]{userCode}));
        if (CollectionUtils.isEmpty(roleList)) {
            return;
        }
        Optional<CustomerUserRelaRole> first = roleList.stream().filter(a -> StringUtils.isBlank((CharSequence)a.getUserCode()) || StringUtils.isBlank((CharSequence)a.getRoleCode()) || !userCode.equals(a.getUserCode())).findFirst();
        Validate.isTrue((!first.isPresent() ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7528\u6237\u7f16\u7801\u6216\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u4e2a\u5ba2\u6237\u7528\u6237", (Object[])new Object[0]);
        Map<String, List<CustomerUserRelaRole>> map = roleList.stream().collect(Collectors.groupingBy(CustomerUserRelaRole::getRoleCode));
        map.entrySet().forEach(a -> Validate.isTrue((((List)a.getValue()).size() <= 1 ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u7684\u89d2\u8272\u7f16\u7801", (Object[])new Object[0]));
        for (CustomerUserRelaRole item : roleList) {
            item.setId(null);
            item.setTenantCode(TenantUtils.getTenantCode());
        }
        this.customerUserRelaRoleRepository.saveBatch(roleList);
    }

    @Override
    public List<CustomerUserRelaRole> findByRoleCodesAndTenantCode(List<String> roleCodeList, String tenantCode) {
        if (CollectionUtils.isEmpty(roleCodeList) || StringUtils.isBlank((CharSequence)tenantCode)) {
            return Lists.newLinkedList();
        }
        return this.customerUserRelaRoleRepository.findByRoleCodesAndTenantCode(roleCodeList, tenantCode);
    }

    @Override
    @Transactional
    public void bind(CustomerUserRelaRoleBindDto dto) {
        List<CustomerUserRelaRole> list;
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getNewRoleCode(), (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getCustomerUserCodeList()), (String)"\u5ba2\u6237\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashSet set = Sets.newHashSet();
        dto.getCustomerUserCodeList().forEach(a -> Validate.isTrue((boolean)set.add(a), (String)"\u5b58\u5728\u91cd\u590d\u7684\u5ba2\u6237\u7528\u6237\u7f16\u7801\u4fe1\u606f", (Object[])new Object[0]));
        ArrayList roleCodeList = Lists.newArrayList((Object[])new String[]{dto.getNewRoleCode()});
        if (StringUtils.isNotBlank((CharSequence)dto.getOldRoleCode())) {
            roleCodeList.add(dto.getOldRoleCode());
        }
        if (CollectionUtils.isNotEmpty(list = this.customerUserRelaRoleRepository.findByUserCodesAndRoleCodes(dto.getCustomerUserCodeList(), roleCodeList))) {
            this.unbind(list.stream().map(UuidEntity::getId).collect(Collectors.toList()), false);
        }
        LinkedList addList = Lists.newLinkedList();
        for (String code : dto.getCustomerUserCodeList()) {
            CustomerUserRelaRole cur = new CustomerUserRelaRole();
            cur.setUserCode(code);
            cur.setRoleCode(dto.getNewRoleCode());
            cur.setTenantCode(TenantUtils.getTenantCode());
            addList.add(cur);
        }
        this.customerUserRelaRoleRepository.saveBatch(addList);
        if (CollectionUtils.isEmpty(this.customerUserRelateRoleEventListeners)) {
            return;
        }
        for (CustomerUserRelateRoleEventListener customerUserRelateRoleEventListener : this.customerUserRelateRoleEventListeners) {
            customerUserRelateRoleEventListener.onBind(dto.getOldRoleCode(), dto.getNewRoleCode(), dto.getCustomerUserCodeList());
        }
    }

    @Override
    @Transactional
    public void unbind(CustomerUserRelaRoleUnbindDto dto) {
        Validate.notNull((Object)dto, (String)"\u89e3\u7ed1\u53c2\u6570\u7f3a\u5931", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getRoleCode(), (String)"\u89d2\u8272\u7f16\u7801\u53c2\u6570\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getCustomerUserCodeList()), (String)"\u5ba2\u6237\u7528\u6237\u7f16\u7801\u53c2\u6570\u7f3a\u5931", (Object[])new Object[0]);
        List<CustomerUserRelaRole> list = this.customerUserRelaRoleRepository.findByUserCodesAndRoleCodes(dto.getCustomerUserCodeList(), Lists.newArrayList((Object[])new String[]{dto.getRoleCode()}));
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(list), (String)"\u65e0\u53ef\u89e3\u7ed1\u7684\u6570\u636e", (Object[])new Object[0]);
        List<String> idList = list.stream().map(UuidEntity::getId).collect(Collectors.toList());
        this.unbind(idList, true);
    }

    @Transactional
    public void unbind(List<String> idList, Boolean needNotifier) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(idList), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<CustomerUserRelaRole> list = this.customerUserRelaRoleRepository.findByIds(idList);
        this.customerUserRelaRoleRepository.removeByIds(idList);
        if (Boolean.FALSE.equals(needNotifier)) {
            return;
        }
        if (CollectionUtils.isEmpty(this.customerUserRelateRoleEventListeners) || CollectionUtils.isEmpty(list)) {
            return;
        }
        List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, CustomerUserRelaRole.class, CustomerUserRelaRoleVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (CustomerUserRelateRoleEventListener customerUserRelateRoleEventListener : this.customerUserRelateRoleEventListeners) {
            customerUserRelateRoleEventListener.onUnbind(voList);
        }
    }
}

