/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.user.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.enums.LockStateEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.user.local.entity.CustomerUser;
import com.biz.crm.mdm.business.customer.user.local.entity.CustomerUserRelaCustomer;
import com.biz.crm.mdm.business.customer.user.local.repository.CustomerUserRepository;
import com.biz.crm.mdm.business.customer.user.local.service.CustomerUserRelaCustomerService;
import com.biz.crm.mdm.business.customer.user.local.service.CustomerUserService;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserPaginationDto;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserResetPasswordDto;
import com.biz.crm.mdm.business.customer.user.sdk.event.CustomerUserEventListener;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.Aes128Utils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;

@Service(value="customerUserService")
public class CustomerUserServiceImpl
implements CustomerUserService {
    @Autowired(required=false)
    private CustomerUserRepository customerUserRepository;
    @Autowired(required=false)
    @Lazy
    private List<CustomerUserEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerUserRelaCustomerService customerUserRelaCustomerService;

    @Override
    public Page<CustomerUser> findByConditions(Pageable pageable, CustomerUserPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new CustomerUserPaginationDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<CustomerUser> byConditions = this.customerUserRepository.findByConditions((Page<CustomerUser>)page, dto);
        if (byConditions == null || !CollectionUtils.isNotEmpty((Collection)byConditions.getRecords())) {
            return byConditions;
        }
        List records = byConditions.getRecords();
        List<String> userCodes = records.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getUserCode())).map(CustomerUser::getUserCode).collect(Collectors.toList());
        List<CustomerUserRelaCustomer> cusUserRelaList = this.customerUserRelaCustomerService.findByUserCodes(userCodes);
        if (CollectionUtils.isEmpty(cusUserRelaList)) {
            return byConditions;
        }
        Map<String, List<CustomerUserRelaCustomer>> cusUserRelaMapByCode = cusUserRelaList.stream().collect(Collectors.groupingBy(CustomerUserRelaCustomer::getUserCode));
        for (CustomerUser customerUser : records) {
            String userCode = customerUser.getUserCode();
            if (!StringUtils.isNotBlank((CharSequence)userCode) || !cusUserRelaMapByCode.containsKey(userCode)) continue;
            customerUser.setCustomerList(cusUserRelaMapByCode.get(userCode));
        }
        return byConditions;
    }

    @Override
    public CustomerUser findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.customerUserRepository.findById(id);
    }

    @Override
    @Transactional
    public CustomerUser create(CustomerUser terminalUser) {
        this.createValidation(terminalUser);
        if (StringUtils.isEmpty((CharSequence)terminalUser.getUserCode())) {
            terminalUser.setUserCode((String)this.generateCodeService.generateCode("KHYH", 1).get(0));
        } else {
            Integer count = this.customerUserRepository.countByUserCode(terminalUser.getUserCode());
            Validate.isTrue((null == count || 1 > count ? 1 : 0) != 0, (String)(terminalUser.getUserCode() + "\u7f16\u7801\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
        terminalUser.setTenantCode(TenantUtils.getTenantCode());
        terminalUser.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        terminalUser.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        terminalUser.setLockState(LockStateEnum.UNLOCK.getCode());
        this.customerUserRepository.saveOrUpdate((Object)terminalUser);
        return terminalUser;
    }

    @Override
    @Transactional
    public CustomerUser update(CustomerUser terminalUser) {
        this.updateValidation(terminalUser);
        this.customerUserRepository.saveOrUpdate((Object)terminalUser);
        return terminalUser;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.customerUserRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        this.onEnableOrDisable(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.customerUserRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        this.onEnableOrDisable(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.customerUserRepository.updateDelFlagByIds(ids);
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return;
        }
        List<CustomerUserVo> voList = this.findVoListByIds(ids);
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        for (CustomerUserEventListener eventListener : this.eventListeners) {
            eventListener.onDelete(voList);
        }
    }

    @Override
    public List<CustomerUser> findDetailsByIdsOrUserCodes(List<String> ids, List<String> userCodes) {
        if (CollectionUtils.isEmpty(ids) && CollectionUtils.isEmpty(userCodes)) {
            return Lists.newLinkedList();
        }
        return this.customerUserRepository.findDetailsByIdsOrUserCodes(ids, userCodes);
    }

    @Override
    @Transactional
    public void resetPassword(CustomerUserResetPasswordDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getIds()), (String)"\u5ba2\u6237\u7528\u6237id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String password = Aes128Utils.decrypt((CharSequence)dto.getPassword(), (String)"1234123412ABCDEF", (Aes128Utils.EncodeType)Aes128Utils.EncodeType.CBC, (Aes128Utils.Padding)Aes128Utils.Padding.PKCS_7_PADDING);
        String md5Password = DigestUtils.md5DigestAsHex((byte[])password.getBytes(StandardCharsets.UTF_8));
        dto.setPassword(md5Password);
        this.customerUserRepository.resetPassword(dto);
    }

    @Override
    public List<CustomerUser> findByRoleCodesAndTenantCode(List<String> roleCodeList, String tenantCode) {
        if (CollectionUtils.isEmpty(roleCodeList) || StringUtils.isBlank((CharSequence)tenantCode)) {
            return Lists.newLinkedList();
        }
        return this.customerUserRepository.findByRoleCodesAndTenantCode(roleCodeList, tenantCode);
    }

    @Override
    public List<CustomerUser> findByUserPhone(String userPhone, String tenantCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{userPhone, tenantCode})) {
            return new ArrayList<CustomerUser>();
        }
        return this.customerUserRepository.findByUserPhone(userPhone, tenantCode);
    }

    @Override
    public List<CustomerUser> findByUserNames(Set<String> userNameSet) {
        if (CollectionUtils.isEmpty(userNameSet)) {
            return Lists.newLinkedList();
        }
        return this.customerUserRepository.findByUserNames(userNameSet);
    }

    private void onEnableOrDisable(List<String> ids, EnableStatusEnum enableStatusEnum) {
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return;
        }
        List<CustomerUserVo> voList = this.findVoListByIds(ids);
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        for (CustomerUserEventListener event : this.eventListeners) {
            if (enableStatusEnum.equals((Object)EnableStatusEnum.ENABLE)) {
                event.onEnable(voList);
                continue;
            }
            if (!enableStatusEnum.equals((Object)EnableStatusEnum.DISABLE)) continue;
            event.onDisable(voList);
        }
    }

    private List<CustomerUserVo> findVoListByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newLinkedList();
        }
        List<CustomerUser> list = this.findDetailsByIdsOrUserCodes(ids, null);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, CustomerUser.class, CustomerUserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void createValidation(CustomerUser terminalUser) {
        Validate.notNull((Object)((Object)terminalUser), (String)"\u5ba2\u6237\u7528\u6237\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminalUser.getUserName(), (String)"\u5ba2\u6237\u7528\u6237\u8d26\u53f7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Integer count1 = this.customerUserRepository.countByUserName(terminalUser.getUserName());
        Validate.isTrue((null == count1 || 1 > count1 ? 1 : 0) != 0, (String)(terminalUser.getUserName() + "\u8d26\u53f7\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)terminalUser.getUserPhone()), (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CustomerUser customerUser = this.customerUserRepository.findUserByPhone(terminalUser.getUserPhone());
        Validate.isTrue((boolean)Objects.isNull((Object)customerUser), (String)"\u7535\u8bdd\u53f7\u7801\u5df2\u7ecf\u88ab\u5360\u7528", (Object[])new Object[0]);
        String password = Aes128Utils.decrypt((CharSequence)terminalUser.getUserPassword(), (String)"1234123412ABCDEF", (Aes128Utils.EncodeType)Aes128Utils.EncodeType.CBC, (Aes128Utils.Padding)Aes128Utils.Padding.PKCS_7_PADDING);
        String md5Password = DigestUtils.md5DigestAsHex((byte[])password.getBytes(StandardCharsets.UTF_8));
        terminalUser.setUserPassword(md5Password);
    }

    private void updateValidation(CustomerUser terminalUser) {
        Validate.notNull((Object)((Object)terminalUser), (String)"\u5ba2\u6237\u7528\u6237\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)terminalUser.getId()), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)terminalUser.getUserPhone()), (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CustomerUser cusUserByPhone = this.customerUserRepository.findUserByPhone(terminalUser.getUserPhone());
        if (!Objects.isNull((Object)cusUserByPhone) && !cusUserByPhone.getId().equals(terminalUser.getId())) {
            throw new IllegalArgumentException("\u7535\u8bdd\u53f7\u7801\u5df2\u7ecf\u88ab\u5360\u7528");
        }
        String currentId = terminalUser.getId();
        CustomerUser current = this.customerUserRepository.findById(currentId);
        Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)terminalUser.getUserCode().equals(current.getUserCode()), (String)"\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        Validate.isTrue((boolean)terminalUser.getUserName().equals(current.getUserName()), (String)"\u8d26\u53f7\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)terminalUser.getUserPassword())) {
            String password = Aes128Utils.decrypt((CharSequence)terminalUser.getUserPassword(), (String)"1234123412ABCDEF", (Aes128Utils.EncodeType)Aes128Utils.EncodeType.CBC, (Aes128Utils.Padding)Aes128Utils.Padding.PKCS_7_PADDING);
            if (!password.equals(current.getUserPassword())) {
                String md5Password = DigestUtils.md5DigestAsHex((byte[])password.getBytes(StandardCharsets.UTF_8));
                terminalUser.setUserPassword(md5Password);
            } else {
                terminalUser.setUserPassword(current.getUserPassword());
            }
        } else {
            terminalUser.setUserPassword(current.getUserPassword());
        }
    }

    @Override
    public CustomerUser findByUserName(String userName) {
        Validate.notBlank((CharSequence)userName, (String)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.customerUserRepository.findByUserName(userName, TenantUtils.getTenantCode());
    }

    @Override
    public CustomerUser findByPhone(String phone) {
        if (StringUtils.isBlank((CharSequence)phone)) {
            return null;
        }
        CustomerUser customerUser = this.customerUserRepository.findUserByPhone(phone);
        return customerUser;
    }
}

