/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.user.local.service.internal;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerRelateOrgVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.customer.user.local.entity.CustomerUser;
import com.biz.crm.mdm.business.customer.user.local.entity.CustomerUserRelaCustomer;
import com.biz.crm.mdm.business.customer.user.local.entity.CustomerUserRelaRole;
import com.biz.crm.mdm.business.customer.user.local.repository.CustomerUserRelaCustomerRepository;
import com.biz.crm.mdm.business.customer.user.local.service.CustomerUserRelaCustomerService;
import com.biz.crm.mdm.business.customer.user.local.service.CustomerUserRelaRoleService;
import com.biz.crm.mdm.business.customer.user.local.service.CustomerUserService;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserDto;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserEventDto;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserRelaCustomerDto;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserRelaRoleDto;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserResetPasswordDto;
import com.biz.crm.mdm.business.customer.user.sdk.event.CustomerUserEventListener;
import com.biz.crm.mdm.business.customer.user.sdk.service.CustomerUserVoService;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserRelaCustomerVo;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserRelaRoleVo;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class CustomerUserVoServiceImpl
implements CustomerUserVoService {
    @Autowired(required=false)
    private CustomerUserService customerUserService;
    @Autowired(required=false)
    private CustomerUserRelaCustomerService customerUserRelaCustomerService;
    @Autowired(required=false)
    private CustomerUserRelaRoleService customerUserRelaRoleService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    @Lazy
    private List<CustomerUserEventListener> eventListeners;
    @Autowired(required=false)
    private CustomerUserRelaCustomerRepository customerUserRelaCustomerRepository;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    public List<CustomerUserVo> findDetailsByIdsOrUserCodes(List<String> ids, List<String> userCodes) {
        List<Object> re = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(ids) && org.apache.commons.collections.CollectionUtils.isEmpty(userCodes)) {
            return re;
        }
        List<CustomerUser> customerUserList = this.customerUserService.findDetailsByIdsOrUserCodes(ids, userCodes);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(customerUserList)) {
            return re;
        }
        List<String> userCodeList = customerUserList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getUserCode())).map(CustomerUser::getUserCode).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(userCodeList)) {
            return re;
        }
        List<CustomerUserRelaCustomer> customerList = this.customerUserRelaCustomerService.findByUserCodes(userCodeList);
        List<CustomerUserRelaRole> roleList = this.customerUserRelaRoleService.findByUserCodes(userCodeList);
        re = this.buildCustomerUserVoList(customerUserList, customerList, roleList);
        return re;
    }

    @Transactional
    public CustomerUserVo create(CustomerUserDto dto) {
        Validate.notNull((Object)dto, (String)"\u5ba2\u6237\u7528\u6237\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        CustomerUser customerUser = (CustomerUser)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CustomerUser.class, HashSet.class, ArrayList.class, new String[0]));
        dto.setLockState(Optional.ofNullable(dto.getLockState()).orElse(EnableStatusEnum.ENABLE.getCode()));
        this.customerUserService.create(customerUser);
        dto.setUserCode(customerUser.getUserCode());
        this.bindExtInfo(dto);
        CustomerUserVo re = this.buildByDtoAndCustomerUser(dto, customerUser);
        CustomerUserEventDto customerUserEventDto = new CustomerUserEventDto();
        customerUserEventDto.setNewest(re);
        customerUserEventDto.setOriginal(null);
        SerializableBiConsumer & Serializable onCreate = CustomerUserEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)customerUserEventDto, CustomerUserEventListener.class, (SerializableBiConsumer)onCreate);
        return re;
    }

    @Transactional
    public CustomerUserVo update(CustomerUserDto dto) {
        List<CustomerUserVo> list;
        Validate.notNull((Object)dto, (String)"\u5ba2\u6237\u7528\u6237\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        dto.setLockState(Optional.ofNullable(dto.getLockState()).orElse(EnableStatusEnum.ENABLE.getCode()));
        Boolean flag = org.apache.commons.collections.CollectionUtils.isNotEmpty(this.eventListeners);
        CustomerUserVo oldVo = null;
        if (Boolean.TRUE.equals(flag) && org.apache.commons.collections.CollectionUtils.isNotEmpty(list = this.findDetailsByIdsOrUserCodes(Lists.newArrayList((Object[])new String[]{dto.getId()}), null))) {
            oldVo = list.get(0);
        }
        CustomerUser customerUser = (CustomerUser)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CustomerUser.class, HashSet.class, ArrayList.class, new String[0]));
        this.customerUserService.update(customerUser);
        dto.setUserCode(customerUser.getUserCode());
        this.bindExtInfo(dto);
        CustomerUserVo re = this.buildByDtoAndCustomerUser(dto, customerUser);
        if (Boolean.FALSE.equals(flag)) {
            return re;
        }
        CustomerUserEventDto customerUserEventDto = new CustomerUserEventDto();
        customerUserEventDto.setOriginal(oldVo);
        customerUserEventDto.setNewest(re);
        SerializableBiConsumer & Serializable onUpdate = CustomerUserEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)customerUserEventDto, CustomerUserEventListener.class, (SerializableBiConsumer)onUpdate);
        return re;
    }

    public CustomerUserVo findDetailsByUserPhone(String userPhone) {
        if (StringUtils.isBlank((CharSequence)userPhone)) {
            return null;
        }
        List<CustomerUser> customerUsers = this.customerUserService.findByUserPhone(userPhone, TenantUtils.getTenantCode());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(customerUsers)) {
            return null;
        }
        CustomerUserVo customerUserVo = (CustomerUserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerUsers.get(0), CustomerUserVo.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList userCodeList = Lists.newArrayList((Object[])new String[]{customerUserVo.getUserCode()});
        List<CustomerUserRelaCustomer> customerList = this.customerUserRelaCustomerService.findByUserCodes(userCodeList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(customerList)) {
            return customerUserVo;
        }
        List customerUserRelaCustomerVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(customerList, CustomerUserRelaCustomer.class, CustomerUserRelaCustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
        customerUserVo.setCustomerInfoList(customerUserRelaCustomerVos);
        return customerUserVo;
    }

    public void updatePasswordByIds(CustomerUserResetPasswordDto dto) {
        this.customerUserService.resetPassword(dto);
    }

    @Transactional
    public void bindExtInfo(CustomerUserDto dto) {
        Validate.notNull((Object)dto, (String)"\u5ba2\u6237\u7528\u6237\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        List customerList = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getCustomerInfoList())) {
            customerList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getCustomerInfoList(), CustomerUserRelaCustomerDto.class, CustomerUserRelaCustomer.class, HashSet.class, ArrayList.class, new String[0]);
            customerList.forEach(a -> a.setUserCode(dto.getUserCode()));
        }
        this.customerUserRelaCustomerService.saveBatch(customerList, dto.getUserCode());
        List roleList = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getRoleInfoList())) {
            roleList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getRoleInfoList(), CustomerUserRelaRoleDto.class, CustomerUserRelaRole.class, HashSet.class, ArrayList.class, new String[0]);
            roleList.forEach(a -> a.setUserCode(dto.getUserCode()));
        }
        this.customerUserRelaRoleService.saveBatch(roleList, dto.getUserCode());
    }

    private List<CustomerUserVo> buildCustomerUserVoList(List<CustomerUser> customerUserList, List<CustomerUserRelaCustomer> customerList, List<CustomerUserRelaRole> roleList) {
        List voList;
        List<CustomerUserVo> re = Lists.newLinkedList();
        Map<Object, Object> mapCustomer = Maps.newHashMap();
        Map<Object, Object> mapRole = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(customerUserList)) {
            return re;
        }
        re = (List)this.nebulaToolkitService.copyCollectionByWhiteList(customerUserList, CustomerUser.class, CustomerUserVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerList)) {
            voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(customerList, CustomerUserRelaCustomer.class, CustomerUserRelaCustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
            mapCustomer = voList.stream().collect(Collectors.groupingBy(CustomerUserRelaCustomerVo::getUserCode));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(roleList)) {
            voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(roleList, CustomerUserRelaRole.class, CustomerUserRelaRoleVo.class, HashSet.class, ArrayList.class, new String[0]);
            mapRole = voList.stream().collect(Collectors.groupingBy(CustomerUserRelaRoleVo::getUserCode));
        }
        for (CustomerUserVo item : re) {
            item.setCustomerInfoList((List)mapCustomer.get(item.getUserCode()));
            item.setRoleInfoList((List)mapRole.get(item.getUserCode()));
        }
        return re;
    }

    private CustomerUserVo buildByDtoAndCustomerUser(CustomerUserDto dto, CustomerUser customerUser) {
        if (Objects.isNull((Object)customerUser) || Objects.isNull(dto)) {
            return null;
        }
        CustomerUserVo vo = (CustomerUserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerUser, CustomerUserVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getCustomerInfoList())) {
            vo.setCustomerInfoList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getCustomerInfoList(), CustomerUserRelaCustomerDto.class, CustomerUserRelaCustomerVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        return vo;
    }

    public CustomerUserVo findByUserName(String userName) {
        CustomerUser customerUser = this.customerUserService.findByUserName(userName);
        if (ObjectUtils.isEmpty((Object)((Object)customerUser))) {
            return null;
        }
        ArrayList userCodeList = Lists.newArrayList();
        userCodeList.add(customerUser.getUserCode());
        List<CustomerUserRelaCustomerVo> customerList = this.customerUserRelaCustomerRepository.findCustomerUserRelaVoByUserCodes(userCodeList);
        List customerCodes = customerList.stream().map(CustomerUserRelaCustomerVo::getCustomerCode).collect(Collectors.toList());
        List userVoList = this.customerVoService.findByCustomerCodes(customerCodes);
        List<CustomerUserRelaRole> roleList = this.customerUserRelaRoleService.findByUserCodes(userCodeList);
        CustomerUserVo customerUserVo = this.buildCustomerUserVo(customerUser, customerList, userVoList, roleList);
        return customerUserVo;
    }

    public CustomerUserVo findByPhone(String phone) {
        CustomerUser customerUser = this.customerUserService.findByPhone(phone);
        if (customerUser == null) {
            return null;
        }
        ArrayList userCodeList = Lists.newArrayList();
        userCodeList.add(customerUser.getUserCode());
        List<CustomerUserRelaCustomerVo> customerList = this.customerUserRelaCustomerRepository.findCustomerUserRelaVoByUserCodes(userCodeList);
        List customerCodes = customerList.stream().map(CustomerUserRelaCustomerVo::getCustomerCode).collect(Collectors.toList());
        List userVoList = this.customerVoService.findByCustomerCodes(customerCodes);
        List<CustomerUserRelaRole> roleList = this.customerUserRelaRoleService.findByUserCodes(userCodeList);
        CustomerUserVo customerUserVo = this.buildCustomerUserVo(customerUser, customerList, userVoList, roleList);
        return customerUserVo;
    }

    public List<CustomerUserVo> findByUserNames(Set<String> userNameSet) {
        List<CustomerUser> list = this.customerUserService.findByUserNames(userNameSet);
        if (ObjectUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(list, CustomerUser.class, CustomerUserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private CustomerUserVo buildCustomerUserVo(CustomerUser customerUser, List<CustomerUserRelaCustomerVo> customerUserRelaCustomerVoList, List<CustomerVo> customerVoList, List<CustomerUserRelaRole> roleList) {
        CustomerUserVo customerUserVo = (CustomerUserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerUser, CustomerUserVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerUserRelaCustomerVoList)) {
            Map customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
            customerUserRelaCustomerVoList.forEach(o -> {
                CustomerVo customerVo = (CustomerVo)customerVoMap.get(o.getCustomerCode());
                if (!ObjectUtils.isEmpty((Object)customerVo)) {
                    if (!CollectionUtils.isEmpty((Collection)customerVo.getOrgList())) {
                        CustomerRelateOrgVo customerRelateOrgVo = (CustomerRelateOrgVo)customerVo.getOrgList().get(0);
                        o.setOrgCode(customerRelateOrgVo.getOrgCode());
                        o.setOrgName(customerRelateOrgVo.getOrgName());
                    }
                    o.setCustomerOrgCode(customerVo.getCustomerOrgCode());
                    o.setCustomerOrgName(customerVo.getCustomerOrgName());
                }
            });
            customerUserVo.setCustomerInfoList(customerUserRelaCustomerVoList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(roleList)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(roleList, CustomerUserRelaRole.class, CustomerUserRelaRoleVo.class, HashSet.class, ArrayList.class, new String[0]);
            customerUserVo.setRoleInfoList(voList);
        }
        return customerUserVo;
    }
}

