package com.biz.crm.mdm.business.customer.user.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.user.sdk.service.CustomerUserRelateCustomerVoService;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserRelateCustomerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 客户用户: CustomerUserRelateCustomerVo: 关联客户
 *
 * @author sunx
 * @date 2021/11/25
 */
@Slf4j
@Api(tags = "客户用户: CustomerUserRelateCustomerVo: 关联客户")
@RestController
@RequestMapping(value = {"/v1/customerUser/customerUserRelaCustomer"})
public class CustomerUserRelateCustomerVoController {

  @Autowired(required = false) private CustomerUserRelateCustomerVoService customerUserRelateCustomerVoService;

  /**
   * 根据客户编码集合获取对应的客户用户关联信息集合
   *
   * @param customerCodeList
   * @return
   */
  @ApiOperation(value = "根据客户编码集合获取对应的客户用户关联信息集合")
  @GetMapping(value = {"/findByCustomerCodes"})
  public Result<List<CustomerUserRelateCustomerVo>> findByCustomerCodes(
      @RequestParam("customerCodeList") List<String> customerCodeList) {
    try {
      List<CustomerUserRelateCustomerVo> list =
          this.customerUserRelateCustomerVoService.findByCustomerCodes(customerCodeList);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
