package com.biz.crm.mdm.business.customer.user.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 客户用户与客户关联客户表(mdm_customer_user_r_customer)实体类
 *
 * @author sunx
 * @since 2021-10-20 16:36:37
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_customer_user_r_customer")
@Table(
    name = "mdm_customer_user_r_customer",
    indexes = {
      @Index(
          name = "mdm_customer_user_r_customer_index",
          columnList = "tenant_code,user_code,customer_code",
          unique = true),
    })
@org.hibernate.annotations.Table(
    appliesTo = "mdm_customer_user_r_customer",
    comment = "客户用户与客户关联客户表")
@ApiModel(value = "CustomerUserRCustomer", description = "客户用户与客户关联客户表")
public class CustomerUserRelaCustomer extends TenantEntity {
  
  private static final long serialVersionUID = 4732458921712013835L;

  /** 是否是主客户标记 */
  @ApiModelProperty("是否是主客户标记")
  @TableField(value = "primary_flag")
  @Column(name = "primary_flag", columnDefinition = "int COMMENT '是否是主客户标记'")
  private Boolean primaryFlag;

  /** 用户编码 */
  @ApiModelProperty("用户编码")
  @TableField(value = "user_code")
  @Column(name = "user_code", length = 32, columnDefinition = "varchar(32) COMMENT '用户编码'")
  private String userCode;

  /** 客户编码 */
  @ApiModelProperty("客户编码")
  @TableField(value = "customer_code")
  @Column(name = "customer_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户编码'")
  private String customerCode;

  /** 客户名称 */
  @ApiModelProperty("客户名称")
  @TableField(value = "customer_name")
  @Column(name = "customer_name", length = 60, columnDefinition = "varchar(60) COMMENT '客户名称'")
  private String customerName;

  /** 是否是当前客户标记 */
  @ApiModelProperty("是否是当前客户标记")
  @TableField(value = "current_flag")
  @Column(name = "current_flag", columnDefinition = "int COMMENT '是否是当前客户标记'")
  private Boolean currentFlag;
}
