package com.biz.crm.mdm.business.customer.user.local.service.notifier;

import com.biz.crm.mdm.business.customer.sdk.dto.CustomerEventDto;
import com.biz.crm.mdm.business.customer.sdk.event.CustomerEventListener;
import com.biz.crm.mdm.business.customer.user.local.service.CustomerUserRelaCustomerService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 客户信息变更事件通知接口实现
 *
 * @author sunx
 * @date 2021/11/3
 */
@Component("customerUserCustomerEventListenerImpl")
public class CustomerEventListenerImpl implements CustomerEventListener {

  @Autowired(required = false) private CustomerUserRelaCustomerService customerUserRelaCustomerService;

  /**
   * 当客户信息删除时触发
   *
   * @param dto
   */
  @Override
  public void onDelete(CustomerEventDto dto) {
    Validate.notNull(dto, "客户信息不能为空");
    Validate.notNull(dto.getOriginal(), "客户信息不能为空");
    Integer count =
        customerUserRelaCustomerService.countByCustomerCodes(
            Lists.newArrayList(dto.getOriginal().getCustomerCode()));
    Validate.isTrue(count < 1, "对应的客户已存在关联的客户用户信息，不能执行删除");
  }
}
