package com.biz.crm.mdm.business.customer.user.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.user.local.service.CustomerUserRelaRoleService;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserRelaRoleBindDto;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserRelaRoleUnbindDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author sunx
 * @date 2021/11/11
 */
@Slf4j
@Api(tags = "客户用户: CustomerUserRRole: 关联角色")
@RestController
@RequestMapping(value = {"/v1/customerUser/customerUserRelaRole"})
public class CustomerUserRelaRoleController {

  @Autowired(required = false) private CustomerUserRelaRoleService customerUserRelaRoleService;

  @ApiOperation(value = "供货关系绑定")
  @PatchMapping(value = {"/bind"})
  public Result<?> bind(@RequestBody CustomerUserRelaRoleBindDto dto) {
    try {
      this.customerUserRelaRoleService.bind(dto);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "解除用户绑定关系")
  @PatchMapping(value = {"/unbind"})
  public Result<?> unbind(@RequestBody CustomerUserRelaRoleUnbindDto dto) {
    try {
      this.customerUserRelaRoleService.unbind(dto);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
