package com.biz.crm.mdm.business.customer.user.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.mdm.business.customer.user.local.entity.CustomerUserRelaCustomer;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserRelaCustomerVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 客户用户与客户关联客户表(CustomerUserRCustomer)表数据库访问层
 *
 * @author sunx
 * @since 2021-10-20 16:36:38
 */
public interface CustomerUserRelaCustomerMapper extends BaseMapper<CustomerUserRelaCustomer> {

  /**
   * 查询关联客户
   * @param userCodeList
   * @param tenantCode
   * @return {@link List< CustomerUserRelaCustomerVo>}
   */
  List<CustomerUserRelaCustomerVo> findCustomerUserRelaVoByUserCodes(@Param("userCodeList") List<String> userCodeList, @Param("tenantCode") String tenantCode);
}
