package com.biz.crm.mdm.business.customer.user.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 客户用户与客户关联客户表dto
 *
 * @author sunx
 * @since 2021-10-20 16:38:14
 */
@Data
@ApiModel(value = "CustomerUserRCustomerDto", description = "客户用户与客户关联客户表dto")
public class CustomerUserRelaCustomerDto extends TenantDto {

  /** 是否是主客户标记 */
  @ApiModelProperty("是否是主客户标记")
  private Boolean primaryFlag;

  /** 用户编码 */
  @ApiModelProperty("用户编码")
  private String userCode;

  /** 客户编码 */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /** 客户名称 */
  @ApiModelProperty("客户名称")
  private String customerName;

  /** 是否是当前客户标记 */
  @ApiModelProperty("是否是当前客户标记")
  private Boolean currentFlag;
}
