package com.biz.crm.mdm.business.customer.user.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 客户用户分页查询dto
 *
 * @author sunx
 * @since 2021-10-20 16:37:34
 */
@Data
@ApiModel(value = "CustomerUserPaginationDto", description = "客户用户分页查询dto")
public class CustomerUserPaginationDto extends TenantFlagOpDto {

  /** 用户账号登录信息 */
  @ApiModelProperty("用户账号登录信息")
  private String userName;

  /** 客户用户编码 */
  @ApiModelProperty("客户用户编码")
  private String userCode;

  /** 人员姓名 */
  @ApiModelProperty("人员姓名")
  private String fullName;

  /** 客户编码 */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /** 客户类型 */
  @ApiModelProperty("客户类型")
  private String userType;
}
