package com.biz.crm.mdm.business.customer.user.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 客户用户vo
 *
 * @author sunx
 * @since 2021-10-20 16:37:37
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "客户用户vo")
public class CustomerUserVo extends TenantFlagOpVo implements NebulaEventDto {

  /**
   * 用户账号登录信息
   */
  @ApiModelProperty("用户账号登录信息")
  private String userName;

  /**
   * 用户编码
   */
  @ApiModelProperty("用户编码")
  private String userCode;

  /**
   * 密码（经过加密的）
   */
  @ApiModelProperty("密码（经过加密的）")
  private String userPassword;

  /**
   * 用户类型
   */
  @ApiModelProperty("用户类型")
  private String userType;

  /**
   * 性别
   */
  @ApiModelProperty("性别")
  private String gender;

  /**
   * 电话
   */
  @ApiModelProperty("电话")
  private String userPhone;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String fullName;

  /**
   * 生效时间
   */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("生效时间")
  private Date startTime;

  /**
   * 失效时间
   */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("失效时间")
  private Date endTime;

  /**
   * 邮箱
   */
  @ApiModelProperty("邮箱")
  private String email;

  /**
   * 锁定状态 003锁定 009正常
   */
  @ApiModelProperty("锁定状态 003锁定 009正常")
  private String lockState;

  /**
   * 最后一次登录时间
   */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("最后一次登录时间")
  private Date lastLoginTime;

  /**
   * 用户头像url
   */
  @ApiModelProperty("用户头像url")
  private String userHeadUrl;

  /**
   * 是否需要强制修改密码 true/false
   */
  @ApiModelProperty("是否需要强制修改密码")
  private Boolean forceChangePassword;

  /**
   * 工号
   */
  @ApiModelProperty("工号")
  private String jobCode;

  /**
   * 员工类型
   */
  @ApiModelProperty("员工类型")
  private String employeeType;

  /**
   * 员工状态
   */
  @ApiModelProperty("员工状态")
  private String employeeStatus;

  /**
   * 身份证号码
   */
  @ApiModelProperty("身份证号码")
  private String identityCardNumber;

  /**
   * 身份证地址
   */
  @ApiModelProperty("身份证地址")
  private String identityCardAddress;

  /**
   * 民族
   */
  @ApiModelProperty("民族")
  private String nationality;

  /**
   * 现住址
   */
  @ApiModelProperty("现住址")
  private String currentAddress;

  /**
   * 政治面貌
   */
  @ApiModelProperty("政治面貌")
  private String politicalAffiliation;

  /**
   * 每隔三个月修改密码更新时间
   */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("每隔三个月修改密码更新时间")
  private Date updatePasswordDate;

  @ApiModelProperty("关联客户")
  private List<CustomerUserRelaCustomerVo> customerInfoList;

  @ApiModelProperty("关联角色")
  private List<CustomerUserRelaRoleVo> roleInfoList;
}

