package com.biz.crm.mdm.business.customer.material.local.deprecated.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.common.sdk.deprecated.model.PageResult;
import com.biz.crm.mdm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.material.local.entity.CustomerMaterial;
import com.biz.crm.mdm.business.customer.material.local.service.CustomerMaterialService;
import com.biz.crm.mdm.business.customer.material.sdk.deprecated.dto.MdmCustomerMaterialReqVo;
import com.biz.crm.mdm.business.customer.material.sdk.deprecated.vo.MdmCustomerMaterialRespVo;
import com.biz.crm.mdm.business.customer.material.sdk.dto.CustomerMaterialDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

/**
 * 旧版MDM客户物料接口
 *
 * @author jerry7
 */
@Slf4j
@RestController
@RequestMapping("/mdmCustomerMaterialController")
@Api(tags = "客户物料(旧版弃用)")
public class MdmCustomerMaterialController {
  @Resource
  private CustomerMaterialService customerMaterialService;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @ApiOperation(value = "分页查询")
  @PostMapping("/list")
  public Result<PageResult<MdmCustomerMaterialRespVo>> list(@RequestBody MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
    mdmCustomerMaterialReqVo = Optional.ofNullable(mdmCustomerMaterialReqVo).orElse(new MdmCustomerMaterialReqVo());
    CustomerMaterialDto dto = nebulaToolkitService
            .copyObjectByWhiteList(mdmCustomerMaterialReqVo, CustomerMaterialDto.class, HashSet.class, ArrayList.class);
    Page<CustomerMaterial> page = customerMaterialService
            .findByConditions(PageRequest.of(mdmCustomerMaterialReqVo.getPageSize(), mdmCustomerMaterialReqVo.getPageNum()), dto);
    if (!CollectionUtils.isEmpty(page.getRecords())) {
      PageResult<MdmCustomerMaterialRespVo> pageResult = PageResult.<MdmCustomerMaterialRespVo>builder()
              .data(new ArrayList<>(nebulaToolkitService
                      .copyCollectionByWhiteList(page.getRecords(), CustomerMaterial.class, MdmCustomerMaterialRespVo.class, HashSet.class, ArrayList.class)))
              .count(page.getTotal())
              .build();
      return Result.ok(pageResult);
    } else {
      PageResult<MdmCustomerMaterialRespVo> pageResult = PageResult.<MdmCustomerMaterialRespVo>builder()
              .data(Lists.newArrayList())
              .count(page.getTotal())
              .build();
      return Result.ok(pageResult);
    }
  }

  @ApiImplicitParams({
          @ApiImplicitParam(name = "id", value = "id", required = true, paramType = "query")
  })
  @ApiOperation(value = "查询")
  @GetMapping("/query")
  public Result<MdmCustomerMaterialRespVo> query(@RequestParam String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    CustomerMaterial customerMaterial = customerMaterialService.findById(id);
    if (ObjectUtils.isEmpty(customerMaterial)) {
      return Result.ok(nebulaToolkitService
              .copyObjectByWhiteList(customerMaterial, MdmCustomerMaterialRespVo.class, HashSet.class, ArrayList.class));
    }
    return Result.ok(new MdmCustomerMaterialRespVo());
  }

  /**
   * 新增
   */
  @ApiOperation(value = "新增")
  @PostMapping("/save")
  public Result<?> save(@RequestBody MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
    Validate.notNull(mdmCustomerMaterialReqVo,"新增客户物料信息不能为空");
    customerMaterialService.create(nebulaToolkitService
            .copyObjectByWhiteList(mdmCustomerMaterialReqVo, CustomerMaterial.class, HashSet.class, ArrayList.class));
    return Result.ok("新增成功");
  }

  /**
   * 更新
   */
  @ApiOperation(value = "更新")
  @PostMapping("/update")
  public Result<?> update(@RequestBody MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
    Validate.notNull(mdmCustomerMaterialReqVo,"新增客户物料信息不能为空");
    customerMaterialService.update(nebulaToolkitService
            .copyObjectByWhiteList(mdmCustomerMaterialReqVo, CustomerMaterial.class, HashSet.class, ArrayList.class));
    return Result.ok("更新成功");
  }

  /**
   * 删除
   */
  @ApiImplicitParams({
          @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @ApiOperation(value = "删除")
  @PostMapping("/delete")
  public Result<?> delete(@RequestBody List<String> ids) {
    customerMaterialService.deleteBatch(ids);
    return Result.ok("删除成功");
  }

  /**
   * 启用
   */
  @ApiImplicitParams({
          @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @ApiOperation(value = "启用")
  @PostMapping("/enable")
  public Result<?> enable(@RequestBody List<String> ids) {
    customerMaterialService.enableBatch(ids);
    return Result.ok("启用成功");
  }

  /**
   * 禁用
   */
  @ApiImplicitParams({
          @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @ApiOperation(value = "禁用")
  @PostMapping("/disable")
  public Result<?> disable(@RequestBody List<String> ids) {
    customerMaterialService.disableBatch(ids);
    return Result.ok("禁用成功");
  }
}
