package com.biz.crm.mdm.business.customer.material.sdk.dto;

import com.biz.crm.mdm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 客户物料请求vo
 *
 * @author jerry7
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerMaterialDto", description = "客户物料请求DTO")
public class CustomerMaterialDto extends TenantFlagOpDto {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("物料编码")
    private String materialCode;

    @ApiModelProperty("条形码")
    private String barCode;

}