package com.biz.crm.mdm.business.customerorg.local.controller;
/**
 * Created by Bao Hongbin on 2021-10-27 17:48.
 */

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customerorg.local.service.CustomerOrgVoService;
import com.biz.crm.mdm.business.customerorg.sdk.dto.CustomerOrgCreateDto;
import com.biz.crm.mdm.business.customerorg.sdk.dto.CustomerOrgPaginationDto;
import com.biz.crm.mdm.business.customerorg.sdk.dto.CustomerOrgUpdateDto;
import com.biz.crm.mdm.business.customerorg.sdk.vo.CustomerOrgVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @program: crm
 * @description: 客户组织控制器
 * @author: Bao Hongbin
 * @create: 2021-10-27 17:48
 **/
@Api(tags = "客户组织：CustomerOrgVo：与客户组织相关的内容")
@Slf4j
@RestController
@RequestMapping("/v1/customerOrg/customerOrg")
public class CustomerOrgVoController {
  @Autowired
  private CustomerOrgVoService customerOrgVoService;

  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询(可适用于列表分页查询和公用分页弹框)", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findByConditions")
  public Result<Page<CustomerOrgVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                      @ApiParam(name = "customerOrgPaginationDto", value = "分页Dto") CustomerOrgPaginationDto customerOrgPaginationDto) {
    try {
      Page<CustomerOrgVo> result = this.customerOrgVoService.findByConditions(pageable, customerOrgPaginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 按照实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   *
   * @param id 主键
   */
  @ApiOperation(value = "按照实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @GetMapping("/findDetailsById")
  public Result<CustomerOrgVo> findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try {
      CustomerOrgVo result = this.customerOrgVoService.findDetailsById(id);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建模型中的基本信息以外，还可以对模型中属于OneToMany关联的明细信息一同进行创建注意：
   * 基于模型的创建操作传入的JSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建模型中的基本信息以外，" +
      "还可以对模型中属于OneToMany关联的明细信息一同进行创建注意：基于模型的创建操作传入的JSON对象，" +
      "其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value = "")
  public Result<CustomerOrgVo> create(
      @RequestBody @ApiParam(name = "customerOrgCreateDto",
          value = "相关的创建过程，http接口。请注意该创建过程除了可以创建模型中的基本信息以外，" +
              "还可以对模型中属于OneToMany关联的明细信息一同进行创建注意：基于模型的创建操作传入的JSON对象，" +
              "其主键信息不能有值，服务端将会自动为其赋予相关值。" +
              "另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") CustomerOrgCreateDto customerOrgCreateDto) {
    try {
      CustomerOrgVo current = this.customerOrgVoService.create(customerOrgCreateDto);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，
   * 包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，
   * 虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（的修改操作传入的SON对象，
   * 其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   */
  @ApiOperation(value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，" +
      "包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，" +
      "但需要开发人员自行在Service层完善其更新过程注意：基于模型的修改操作传入的JSON对象，其主键信息必须有值，" +
      "服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PatchMapping(value = "")
  public Result<CustomerOrgVo> update(
      @RequestBody @ApiParam(name = "customerOrgUpdateDto",
          value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，" +
              "包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，" +
              "虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型的修改操作传入的JSON对象，" +
              "其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，" +
              "系统将返回该对象的基本信息（不包括任何关联信息）") CustomerOrgUpdateDto customerOrgUpdateDto) {
    try {
      CustomerOrgVo current = this.customerOrgVoService.update(customerOrgUpdateDto);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result<?> enable(@RequestBody List<String> ids) {
    try {
      this.customerOrgVoService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result<?> disable(@RequestBody List<String> ids) {
    try {
      this.customerOrgVoService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除
   */
  @ApiOperation(value = "删除")
  @DeleteMapping("/delete")
  public Result<?> delete(@RequestParam("ids") List<String> ids) {
    try {
      this.customerOrgVoService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("重置降维编码")
  @PatchMapping("/resetAllRuleCode")
  public Result<?> resetAllRuleCode() {
    try {
      this.customerOrgVoService.resetAllRuleCode();
      return Result.ok("重置降维编码成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取所有的产品层级
   */
  @ApiOperation(value = "获取所有的产品层级")
  @GetMapping("/findAll")
  public Result<List<CustomerOrgVo>> findAll() {
    try {
      List<CustomerOrgVo> result = this.customerOrgVoService.findAll();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
