package com.biz.crm.mdm.business.customerorg.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.mdm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 客户组织职位关联实体类
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerOrgPosition", description = "客户组织职位关联实体类")
@TableName("mdm_customer_org_position")
@Entity
@Table(name = "mdm_customer_org_position", indexes = {
    @Index(name = "MDM_PRODUCT_LEVEL_INDEX1", columnList = "customer_org_code", unique = true),
    @Index(name = "MDM_PRODUCT_LEVEL_INDEX2", columnList = "position_code"),
})
@org.hibernate.annotations.Table(appliesTo = "mdm_customer_org_position", comment = "客户组织职位关联表")
public class CustomerOrgPosition extends UuidOpEntity {


  private static final long serialVersionUID = -905545375934629666L;
  /**
   * 客户组织编码
   */
  @ApiModelProperty("客户组织编码")
  @TableField(value = "customer_org_code")
  @Column(name = "customer_org_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户组织编码 '")
  private String customerOrgCode;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  @TableField(value = "position_code")
  @Column(name = "position_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 职位编码 '")
  private String positionCode;

}
