package com.biz.crm.mdm.business.customerorg.local.listener;
/**
 * Created by Bao Hongbin on 2021-10-12 17:15.
 */

import com.biz.crm.mdm.business.customerorg.sdk.event.CustomerOrgEventListener;
import com.biz.crm.mdm.business.customerorg.sdk.vo.CustomerOrgVo;
import com.bizunited.nebula.common.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @program: crm
 * @description: TODO 推送作日志（目前尚无记录日志功能，该功能将在后续改造中实现，目前无法实现推送，暂时记录为info级系统日志）
 * @author: Bao Hongbin
 **/
@Component
@Slf4j
public class CustomerOrgEventLogListener implements CustomerOrgEventListener {
  /**
   * 新增客户组织记录日志
   *
   * @param customerOrgVos
   */
  @Override
  public void onBatchCreate(List<CustomerOrgVo> customerOrgVos) {
    log.info("新增客户组织信息：{}", JsonUtils.obj2JsonString(customerOrgVos));
  }

  /**
   * 更新客户组织记录日志
   *
   * @param customerOrgVos
   */
  @Override
  public void onBatchUpdate(List<CustomerOrgVo> customerOrgVos) {
    log.info("更新客户组织信息：{}", JsonUtils.obj2JsonString(customerOrgVos));
  }

  /**
   * 删除客户组织记录日志
   *
   * @param customerOrgVos
   */
  @Override
  public void onBatchDelete(List<CustomerOrgVo> customerOrgVos) {
    log.info("删除客户组织信息：{}", JsonUtils.obj2JsonString(customerOrgVos));
  }

  /**
   * 启用客户组织记录日志
   *
   * @param customerOrgVos
   */
  @Override
  public void onBatchEnable(List<CustomerOrgVo> customerOrgVos) {
    log.info("启用客户组织信息：{}", JsonUtils.obj2JsonString(customerOrgVos));
  }

  /**
   * 禁用客户组织记录日志
   *
   * @param customerOrgVos
   */
  @Override
  public void onBatchDisable(List<CustomerOrgVo> customerOrgVos) {
    log.info("禁用客户组织信息：{}", JsonUtils.obj2JsonString(customerOrgVos));
  }
}
