package com.biz.crm.mdm.business.customerorg.local.repository;
/**
 * Created by Bao Hongbin on 2021-11-01 16:48.
 */

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.customerorg.local.entity.CustomerOrgPosition;
import com.biz.crm.mdm.business.customerorg.local.mapper.CustomerOrgPositionMapper;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @program: crm
 * @description: 客户组织和职位关联数据库访问类
 * @author: Bao Hongbin
 * @create: 2021-11-01 16:48
 **/
@Component
public class CustomerOrgPositionRepository extends ServiceImpl<CustomerOrgPositionMapper, CustomerOrgPosition> {

  /**
   * 更加客户组织编码和职位集合删除关联关系
   * @param customerOrgCode
   * @param positionCodeList
   */
  public void removeRelationByCustomerOrgCodeAndPositionCodes(String customerOrgCode, List<String> positionCodeList) {
    Validate.notEmpty(customerOrgCode, "客户组织编码必须传入！");
    Validate.isTrue(!CollectionUtils.isEmpty(positionCodeList),
        "需要关联的职位编码不能为空！");
    this.lambdaUpdate()
        .eq(CustomerOrgPosition::getCustomerOrgCode, customerOrgCode)
        .in(CustomerOrgPosition::getPositionCode, positionCodeList)
        .remove();
  }

  public List<CustomerOrgPosition> findListByPositionCode(List<String> positionCode) {
    return this.lambdaQuery().in(CustomerOrgPosition::getPositionCode,positionCode).list();
  }
}
