package com.biz.crm.mdm.business.customerorg.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customerorg.sdk.dto.CustomerOrgCreateDto;
import com.biz.crm.mdm.business.customerorg.sdk.dto.CustomerOrgPaginationDto;
import com.biz.crm.mdm.business.customerorg.sdk.dto.CustomerOrgUpdateDto;
import com.biz.crm.mdm.business.customerorg.sdk.vo.CustomerOrgVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * Created by Bao Hongbin on 2021-10-27 17:51.
 */
public interface CustomerOrgVoService {
  /**
   * 多条件分页查询(可适用于列表分页查询和公用分页弹框)
   *
   * @param pageable
   * @param customerOrgPaginationDto
   * @return
   */
  Page<CustomerOrgVo> findByConditions(Pageable pageable, CustomerOrgPaginationDto customerOrgPaginationDto);

  /**
   * 按照实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   *
   * @param id
   * @return
   */
  CustomerOrgVo findDetailsById(String id);

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建模型中的基本信息以外，还可以对模型中属于OneToMany关联的明细信息一同进行创建注意：
   * 基于模型的创建操作传入的JSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   *
   * @param customerOrgCreateDto
   * @return
   */
  CustomerOrgVo create(CustomerOrgCreateDto customerOrgCreateDto);

  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，
   * 包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，
   * 虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（的修改操作传入的SON对象，
   * 其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   *
   * @param customerOrgUpdateDto
   * @return
   */
  CustomerOrgVo update(CustomerOrgUpdateDto customerOrgUpdateDto);

  /**
   * 启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 删除
   *
   * @param ids
   */
  void deleteBatch(List<String> ids);

  /**
   * 重置降维编码
   */
  void resetAllRuleCode();

  /**
   * 获取所有的产品层级
   *
   * @return
   */
  List<CustomerOrgVo> findAll();

}
