package com.biz.crm.mdm.business.customerorg.local.service.internal;
/**
 * Created by Bao Hongbin on 2021-11-02 16:13.
 */

import com.biz.crm.mdm.business.customerorg.local.entity.CustomerOrgPosition;
import com.biz.crm.mdm.business.customerorg.local.repository.CustomerOrgPositionRepository;
import com.biz.crm.mdm.business.position.sdk.event.PositionEventListener;
import com.biz.crm.mdm.business.position.sdk.vo.PositionEventVo;
import com.biz.crm.mdm.business.position.sdk.vo.PositionRelationVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @program: crm
 * @description:
 * @author: Bao Hongbin
 * @create: 2021-11-02 16:13
 **/
@Service
public class PositionEventListenerImpl implements PositionEventListener {
  @Autowired
  private CustomerOrgPositionRepository customerOrgPositionRepository;

  @Override
  public void onCreate(PositionEventVo vo) {

  }

  @Override
  public void onUpdate(PositionEventVo oldVo, PositionEventVo newVo) {

  }

  @Override
  public void onDisable(List<PositionEventVo> voList) {

  }

  @Override
  public void onEnable(List<PositionEventVo> voList) {

  }

  @Override
  public void onDelete(List<PositionEventVo> voList) {
    if (CollectionUtils.isEmpty(voList)) {
      return;
    }
    List<String> positionCode = voList.stream().map(PositionEventVo::getPositionCode).collect(Collectors.toList());
    List<CustomerOrgPosition> customerOrgPositions = customerOrgPositionRepository.findListByPositionCode(positionCode);
    Validate.isTrue(CollectionUtils.isEmpty(customerOrgPositions), "存在已被客户组织关联的职位");
  }

  @Override
  public List<PositionRelationVo> onRequestByPositionCodes(List<String> positionCodes) {
    return null;
  }
}
